/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ArrayBackedExtendedAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ExtendedAttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ExtendedAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.common.ExtendedAttributesBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

class ArrayBackedExtendedAttributesBuilder
implements ExtendedAttributesBuilder {
    private final List<Object> data;

    ArrayBackedExtendedAttributesBuilder() {
        this.data = new ArrayList<Object>();
    }

    ArrayBackedExtendedAttributesBuilder(List<Object> data) {
        this.data = data;
    }

    @Override
    public ExtendedAttributes build() {
        if (this.data.size() == 2 && this.data.get(0) != null) {
            return new ArrayBackedExtendedAttributes(this.data.toArray());
        }
        return ArrayBackedExtendedAttributes.sortAndFilterToAttributes(this.data.toArray());
    }

    @Override
    public <T> ExtendedAttributesBuilder put(ExtendedAttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        this.data.add(key);
        this.data.add(value);
        return this;
    }

    @Override
    public ExtendedAttributesBuilder removeIf(Predicate<ExtendedAttributeKey<?>> predicate) {
        if (predicate == null) {
            return this;
        }
        for (int i = 0; i < this.data.size() - 1; i += 2) {
            Object entry = this.data.get(i);
            if (!(entry instanceof ExtendedAttributeKey) || !predicate.test((ExtendedAttributeKey)entry)) continue;
            this.data.set(i, null);
            this.data.set(i + 1, null);
        }
        return this;
    }

    static List<Double> toList(double ... values) {
        Double[] boxed = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Long> toList(long ... values) {
        Long[] boxed = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Boolean> toList(boolean ... values) {
        Boolean[] boxed = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }
}

