package com.liquidnet.service.adam.mapper;

import com.liquidnet.service.adam.entity.AdamMemberCodeBatch;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Update;

/**
 * <p>
 * 会员码批次记录 Mapper 接口
 * </p>
 *
 * @author liquidnet
 * @since 2021-09-24
 */
public interface AdamMemberCodeBatchMapper extends BaseMapper<AdamMemberCodeBatch> {

    @Update("update adam_member_code_batch amcb\n" +
            "    inner join (\n" +
            "        select batch_no, count(1) ct from adam_member_code where batch_no is not null and state = 1 group by batch_no\n" +
            "    ) t on amcb.batch_no = t.batch_no\n" +
            "set amcb.use_num=t.ct, amcb.updated_at=sysdate()\n" +
            "where amcb.state = 1 and amcb.gen_num <> amcb.use_num")
    int updateUseNum();
}
