package com.liquidnet.commons.lang.util;

/**
 * @author <a href="mailto:zoumeng@kowlone.com">kowlone</a>
 * @version 1.0 2016年11月24日 17:35
 */
public class VersionCompareUtil {
    /**
     * 比较版本号的大小,前者大则返回一个正数,后者大返回一个负数,相等则返回0
     * @param version1  App 传的版本号(旧版本App有可能没传版本号)
     * @param version2 比较的版本号
     * @return
     */
    public static int compareVersion(String version1, String version2)throws Exception{
        if (version1 == null || version2 == null) {
            throw new Exception("compareVersion error:illegal params.");
        }
        String[] versionArray1 = version1.split("\\.");//注意此处为正则匹配，不能用"."；
        String[] versionArray2 = version2.split("\\.");
        int idx = 0;
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        while (idx < minLength
            && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0//先比较长度
            && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0) {//再比较字符
            ++idx;
        }
        //如果已经分出大小，则直接返回，如果未分出大小，则再比较位数，有子版本的为大；
        diff = (diff != 0) ? diff : versionArray1.length - versionArray2.length;
        return diff;
    }
    public static void main(String[] args){
        try {
            System.out.println(compareVersion("1.1.0","1.0.2"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
