package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.service.goblin.entity.AdamUserBusiAcct;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamUserBizAcctVo", description = "用户业务账号信息")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class GoblinUserBizAcctVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 7428532456309328881L;
    @ApiModelProperty(position = 11, value = "业务码[NFT_ZX-至信数字藏品账号]")
    private String bizCode;
    @ApiModelProperty(position = 12, value = "业务账号状态[1-已开通]")
    private Integer state;
    @ApiModelProperty(position = 13, value = "业务账号ID")
    private String uuid;

    private static final GoblinUserBizAcctVo obj = new GoblinUserBizAcctVo();

    public static GoblinUserBizAcctVo getNew() {
        try {
            return (GoblinUserBizAcctVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinUserBizAcctVo();
        }
    }

    public GoblinUserBizAcctVo copy(AdamUserBusiAcct source) {
        if (null == source) return this;
        this.setBizCode(source.getBusi());
        this.setUuid(source.getUuid());
        this.setState(source.getState());
        return this;
    }
}
