package com.liquidnet.service.platform.controller.kylin;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.service.impl.kylin.DataImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "数据迁移 (会重复)")
@RestController
@RequestMapping("data")
public class DataController {

    @Autowired
    private DataImpl data;

    @PostMapping("performance")
    @ApiOperation("演出数据迁移")
    public ResponseDto<Boolean> performance() {
        Boolean result = data.performance();
        return ResponseDto.success(result);
    }

    @PostMapping("order")
    @ApiOperation("订单数据迁移")
    public ResponseDto<Boolean> order(String month) {
        Boolean result = data.order(month);
        return ResponseDto.success(result);
    }

    @PostMapping("roadShow")
    @ApiOperation("巡演数据迁移")
    public ResponseDto<Boolean> roadShow() {
        Boolean result = data.roadShow();
        return ResponseDto.success(result);
    }

    @PostMapping("childAccount")
    @ApiOperation("验票子账号数据迁移")
    public ResponseDto<Boolean> childAccount() {
        Boolean result = data.childAccount();
        return ResponseDto.success(result);
    }

}
