package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinGoodsInfoListVo", description = "商品SPU List")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinGoodsInfoListVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -4712015317981742851L;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 20, value = "封面图片地址[256]")
    private String coverPic;
    @ApiModelProperty(position = 13, value = "商品名称[100]")
    private String name;
    @ApiModelProperty(position = 16, value = "价格区间MIN[20,2]")
    private BigDecimal priceGe;
    @ApiModelProperty(position = 15, value = "销售价-原价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 52, value = "商品标签列表")
    private List<GoblinGoodsTagVo> tagVoList;
    private static final GoblinGoodsInfoListVo obj = new GoblinGoodsInfoListVo();

    public static GoblinGoodsInfoListVo getNew() {
        try {
            return (GoblinGoodsInfoListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsInfoListVo();
        }
    }
/*    public int compareTo(GoblinGoodsInfoVo arg0) {
        return this.getCount().compareTo(arg0.getCount());
    }*/

}
