package com.liquidnet.service.reconciliation.util.excel2bean.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: ExcelCell
 * @class: ExcelCell
 * @Package com.liquidnet.service.reconciliation.util.excel2bean.annotation
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/22 10:19
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ExcelCell {
    int cellIndex() default 0;//所在列，从0开始
    Class<?> dataType() default String.class;//数据类型，默认为String
    String formatPattern() default "";//格式化
    String fieldName();//列对应类的属性名称
    String desc() default "";//描述
    boolean notNull() default true;//是否可为空，默认可为空
}
