package com.liquidnet.service.kylin.controller.admin;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.service.impl.admin.KylinOrderRefundsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 后台单订单退款 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-25 10:58 上午
 */

@Api(tags = "后端-单订单退款")
@RestController
@RequestMapping("admin/refund")

public class KylinOrderRefundAdminController {

    @Autowired
    private KylinOrderRefundsServiceImpl kylinOrderRefundsServiceImpl;

    @PostMapping("apply")
    @ApiOperation("申请退款")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "String", name = "orderTicketsId", value = "订单id", required = true),
            @ApiImplicitParam(type = "body", dataType = "String", name = "orderRefundBatchesId", value = "批量id"),
            @ApiImplicitParam(type = "body", dataType = "String", name = "refundData", value = "退款数据"),
            @ApiImplicitParam(type = "body", dataType = "String", name = "reason", value = "备注", required = true)
    })
    public ResponseDto<Object> refundApply(
            @RequestBody String orderTicketsId,
            @RequestBody String orderRefundBatchesId,
            @RequestBody String refundData,
            @RequestBody String reason
    ) {
        try {
            Boolean res = kylinOrderRefundsServiceImpl.refundApply(orderTicketsId, reason, orderRefundBatchesId, refundData);
            if (res) {
                return ResponseDto.success();
            } else {
                return ResponseDto.failure("申请退款失败");
            }
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }

    }

}
