package com.liquidnet.service.kylin.service.impl.admin;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.entity.KylinOrderRefunds;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import com.liquidnet.service.kylin.mapper.KylinOrderRefundsMapper;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketsMapper;
import com.liquidnet.service.kylin.service.IKylinOrderRefundsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 订单退款表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-26
 */
@Service
public class KylinOrderRefundsServiceImpl extends ServiceImpl<KylinOrderRefundsMapper, KylinOrderRefunds> implements IKylinOrderRefundsService {
    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Autowired
    private KylinRefundsStatusServiceImpl kylinRefundsStatusServiceImpl;

    public Boolean refundApply(String orderTicketsId, String reason, String orderRefundBatchesId, String refundData) throws Exception {
        int count = 0;
        count = kylinOrderTicketsMapper.selectCount(
                new UpdateWrapper<KylinOrderTickets>().eq("order_tickets_id", orderTicketsId).eq("coupon_type2", "full")
        );
        if (count > 0) {
            throw new Exception("使用满减券 暂不能退款");
        }

        boolean res = kylinRefundsStatusServiceImpl.orderTicketRefunding(orderTicketsId, refundData, reason, orderRefundBatchesId);
        if (res) {
            return true;
        } else {
            return false;
        }
    }
}
