package com.liquidnet.service.adam.controller.admin;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.adam.service.processor.*;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@ApiSupport(order = 90062)
@Api(tags = "DM")
@Slf4j
@Validated
@RestController
@RequestMapping("dm")
public class AdamDMAdminController extends AdamBaseController {
    @Autowired
    DMUserInformationProcessor dmUserInformationProcessor;
    @Autowired
    DMThirdPartsProcessor dmThirdPartsProcessor;
    @Autowired
    DMRealNameProcessor dmRealNameProcessor;
    @Autowired
    DMUserMemberProcessor dmUserMemberProcessor;
    @Autowired
    DMEntersProcessor dmEntersProcessor;
    @Autowired
    DMAddressesProcessor dmAddressesProcessor;
    @Autowired
    DMTracesInfoProcessor dmTracesInfoProcessor;
    @Autowired
    DMMemberOrderProcessor dmMemberOrderProcessor;
    @Autowired
    DMMemberCodeProcessor dmMemberCodeProcessor;
    @Autowired
    DMCollectionProcessor dmCollectionProcessor;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "T - user")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", name = "dg", allowableValues = "0"),
            @ApiImplicitParam(type = "form", name = "lS", allowableValues = "220"),
    })
    @GetMapping(value = {"user"})
    public ResponseDto<Object> dataMigrationForUser(@RequestParam(required = false) Integer dg,
                                                    @RequestParam(required = false) Integer lS,
                                                    @RequestParam(required = false) String incrDt,
                                                    @RequestParam(required = false) String flg,
                                                    @RequestParam(required = false) String flu
    ) {
        if (null != dg) {
            ExecutorService exec = Executors.newFixedThreadPool(lS);
            for (int i = 0; i < dg; i++) {
                final int k = i;
                exec.execute(() -> {
                    log.info("==================" + k);
                    dmUserInformationProcessor.dataProcessing(k, lS, null, null, k == 0 ? "1" : "");
                });
            }
            exec.shutdown();
        } else {
            dmUserInformationProcessor.dataProcessing(null, null, incrDt, flg, flu);
        }
        return ResponseDto.success(dg);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "T - tpa")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", name = "dg", allowableValues = "0"),
            @ApiImplicitParam(type = "form", name = "lS", allowableValues = "45"),
    })
    @GetMapping(value = {"tpa"})
    public ResponseDto<Object> dataMigrationForTpa(@RequestParam(required = false) Integer dg,
                                                   @RequestParam(required = false) Integer lS,
                                                   @RequestParam(required = false) String incrDt,
                                                   @RequestParam(required = false) String flg,
                                                   @RequestParam(required = false) String flu
    ) {
        if (null != dg) {
            ExecutorService exec = Executors.newFixedThreadPool(lS);
            for (int i = 0; i < dg; i++) {
                final int k = i;
                exec.execute(() -> {
                    log.info("==================" + k);
                    dmThirdPartsProcessor.dataProcessing(k, lS, null, null, k == 0 ? "1" : "");
                });
            }
            exec.shutdown();
        } else {
            dmThirdPartsProcessor.dataProcessing(null, null, incrDt, flg, flu);
        }
        return ResponseDto.success(dg);
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "T - real")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", name = "dg", allowableValues = "0"),
            @ApiImplicitParam(type = "form", name = "lS", allowableValues = "2"),
    })
    @GetMapping(value = {"real"})
    public ResponseDto<Object> dataMigrationForReal(@RequestParam(required = false) Integer dg,
                                                    @RequestParam(required = false) Integer lS,
                                                    @RequestParam(required = false) String incrDt,
                                                    @RequestParam(required = false) String flg,
                                                    @RequestParam(required = false) String flu
    ) {
        if (null != dg) {
            ExecutorService exec = Executors.newFixedThreadPool(lS);
            for (int i = 0; i < dg; i++) {
                final int k = i;
                exec.execute(() -> {
                    log.info("==================" + k);
                    dmRealNameProcessor.dataProcessing(k, lS, null, null, k == 0 ? "1" : "");
                });
            }
            exec.shutdown();
        } else {
            dmRealNameProcessor.dataProcessing(null, null, incrDt, flg, flu);
        }
        return ResponseDto.success(dg);
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "T - collect")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", name = "dg", allowableValues = "0"),
            @ApiImplicitParam(type = "form", name = "lS", allowableValues = "15"),
    })
    @GetMapping(value = {"collect"})
    public ResponseDto<Object> dataMigrationForCollect(@RequestParam(required = false) Integer dg,
                                                       @RequestParam(required = false) Integer lS,
                                                       @RequestParam(required = false) String incrDt,
                                                       @RequestParam(required = false) String flg,
                                                       @RequestParam(required = false) String flu
    ) {
        if (null != dg) {
            ExecutorService exec = Executors.newFixedThreadPool(lS);
            for (int i = 0; i < dg; i++) {
                final int k = i;
                exec.execute(() -> {
                    log.info("==================" + k);
                    dmCollectionProcessor.dataProcessing(k, lS, null, null, k == 0 ? "1" : "");
                });
            }
            exec.shutdown();
        } else {
            dmCollectionProcessor.dataProcessing(null, null, incrDt, flg, flu);
        }
        return ResponseDto.success(dg);
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "T - enters")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", name = "dg", allowableValues = "0"),
            @ApiImplicitParam(type = "form", name = "lS", allowableValues = "93"),
    })
    @GetMapping(value = {"enters"})
    public ResponseDto<Object> dataMigrationForEnters(@RequestParam(required = false) Integer dg,
                                                      @RequestParam(required = false) Integer lS,
                                                      @RequestParam(required = false) String incrDt,
                                                      @RequestParam(required = false) String flg,
                                                      @RequestParam(required = false) String flu
    ) {
        if (null != dg) {
            ExecutorService exec = Executors.newFixedThreadPool(lS);
            for (int i = 0; i < dg; i++) {
                final int k = i;
                exec.execute(() -> {
                    log.info("==================" + k);
                    dmEntersProcessor.dataProcessing(k, lS, null, null, k == 0 ? "1" : "");
                });
            }
            exec.shutdown();
        } else {
            dmEntersProcessor.dataProcessing(null, null, incrDt, flg, flu);
        }
        return ResponseDto.success(dg);
    }

    @ApiOperationSupport(order = 6)
    @ApiOperation(value = "T - addr")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", name = "dg", allowableValues = "0"),
            @ApiImplicitParam(type = "form", name = "lS", allowableValues = "27"),
    })
    @GetMapping(value = {"addr"})
    public ResponseDto<Object> dataMigrationForAddr(@RequestParam(required = false) Integer dg,
                                                    @RequestParam(required = false) Integer lS,
                                                    @RequestParam(required = false) String incrDt,
                                                    @RequestParam(required = false) String flg,
                                                    @RequestParam(required = false) String flu
    ) {
        if (null != dg) {
            ExecutorService exec = Executors.newFixedThreadPool(lS);
            for (int i = 0; i < dg; i++) {
                final int k = i;
                exec.execute(() -> {
                    log.info("==================" + k);
                    dmAddressesProcessor.dataProcessing(k, lS, null, null, k == 0 ? "1" : "");
                });
            }
            exec.shutdown();
        } else {
            dmAddressesProcessor.dataProcessing(null, null, incrDt, flg, flu);
        }
        return ResponseDto.success(dg);
    }

    @ApiOperationSupport(order = 7)
    @ApiOperation(value = "T - vip")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", name = "dg", allowableValues = "0"),
            @ApiImplicitParam(type = "form", name = "lS", allowableValues = "2"),
    })
    @GetMapping(value = {"vip"})
    public ResponseDto<Object> dataMigrationForVip(@RequestParam(required = false) Integer dg,
                                                   @RequestParam(required = false) Integer lS,
                                                   @RequestParam(required = false) String incrDt,
                                                   @RequestParam(required = false) String flg,
                                                   @RequestParam(required = false) String flu
    ) {
        if (null != dg) {
            ExecutorService exec = Executors.newFixedThreadPool(lS);
            for (int i = 0; i < dg; i++) {
                final int k = i;
                exec.execute(() -> {
                    log.info("==================" + k);
                    dmUserMemberProcessor.dataProcessing(k, lS, null, null, k == 0 ? "1" : "");
                });
            }
            exec.shutdown();
        } else {
            dmUserMemberProcessor.dataProcessing(null, null, incrDt, flg, flu);
        }
        return ResponseDto.success(dg);
    }

    @ApiOperationSupport(order = 8)
    @ApiOperation(value = "morder")
    @GetMapping(value = {"morder"})
    public ResponseDto<Object> dataMigrationForMOrder(@RequestParam(required = false) Integer dg,
                                                      @RequestParam(required = false) Integer lS,
                                                      @RequestParam(required = false) String incrDt,
                                                      @RequestParam(required = false) String flg,
                                                      @RequestParam(required = false) String flu
    ) {
        dmMemberOrderProcessor.dataProcessing(null, null, incrDt, flg, flu);
        return ResponseDto.success(dg);
    }

    @ApiOperationSupport(order = 9)
    @ApiOperation(value = "mcode")
    @GetMapping(value = {"mcode"})
    public ResponseDto<Object> dataMigrationForMCode(@RequestParam(required = false) Integer dg,
                                                     @RequestParam(required = false) Integer lS,
                                                     @RequestParam(required = false) String incrDt,
                                                     @RequestParam(required = false) String flg,
                                                     @RequestParam(required = false) String flu
    ) {
        dmMemberCodeProcessor.dataProcessing(null, null, incrDt, flg, flu);
        return ResponseDto.success(dg);
    }

    @ApiOperationSupport(order = 10)
    @ApiOperation(value = "traces")
    @GetMapping(value = {"traces"})
    public ResponseDto<Object> dataMigrationForTraces(@RequestParam(required = false) Integer dg,
                                                      @RequestParam(required = false) Integer lS,
                                                      @RequestParam(required = false) String incrDt,
                                                      @RequestParam(required = false) String flg,
                                                      @RequestParam(required = false) String flu
    ) {
        dmTracesInfoProcessor.dataProcessing(null, null, incrDt, flg, flu);
        return ResponseDto.success(dg);
    }
}
