package com.liquidnet.service.platform.service.impl.smile;

import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.dto.vo.SellDataOneVO;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketsMapper;
import com.liquidnet.service.smile.entity.SmileUser;
import com.liquidnet.service.smile.mapper.SmileUserMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


/**
 * <p>
 * 订单 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Service
@Slf4j
public class SellDataInfoImpl {
    @Autowired
    SmileUserMapper smileUserMapper;
    @Autowired
    private KylinOrderTicketsMapper orderTicketsMapper;
    @Autowired
    private MongoTemplate mongoTemplate;

   public void setData(){
       //1、查到用户
       List<SmileUser>  list=smileUserMapper.selectUserList(null);
       for(SmileUser smileUser:list){
            //-- 看这个人有哪些演出维度的订单  (支付的、演出id，该用户的。)
           if(StringUtil.isNotBlank(smileUser.getUid())){
               List<Map> list1=orderTicketsMapper.getUserOrder(smileUser.getUid());
               for(Map a:list1){
                   String performanceId=a.get("yanchuId")==null?"":a.get("yanchuId").toString();
                   //获取 该人下 该演出id 的 所有订单
                   List<Map> list2=orderTicketsMapper.getUserSellOneDate(smileUser.getUid(),performanceId);
                   for(Map a1:list2){
                       SellDataOneVO sellDataOneVO=SellDataOneVO.getNew();
                       sellDataOneVO.setTicketName(a1.get("title")==null?"":a1.get("title").toString());
                       sellDataOneVO.setTicketNumber(a1.get("number")==null?0:Integer.parseInt(a1.get("number").toString()));
                       sellDataOneVO.setPiaoTi(new BigDecimal(a1.get("paioTi")==null?"":a1.get("paioTi").toString()));
                       //commission
                   }

               }
           }

       }
   }

}
