package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.service.kylin.dao.OrderTicketsListDao;
import com.liquidnet.service.kylin.dao.PerformanceSponsorDao;
import com.liquidnet.service.kylin.dto.param.admin.OrderListReq;
import com.liquidnet.service.kylin.dto.vo.admin.OrderDetailsAdminVo;
import com.liquidnet.service.kylin.service.admin.IKylinOrderTicketsAdminService;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 订单Controller
 *
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/order")
public class KylinOrderTicketsController extends BaseController {
    private String prefix = "zhengzai/kylin/order";

    @Autowired
    private IKylinOrderTicketsAdminService iKylinOrderTicketsAdminService;

    @Autowired
    private IKylinPerformancesAdminService kylinPerformancesService;

    @RequiresPermissions("kylin:order:orderlist:view")
    @GetMapping("/orderList")
    public String tickets() {
        return prefix + "/orderList/orderList";
    }

    /**
     * 查询订单列表
     */
    @Log(title = "演出订单", businessType = BusinessType.LIST)
    @RequiresPermissions("kylin:order:orderlist:list")
    @PostMapping("/orderList/list")
    @ResponseBody
    public TableDataInfo list(OrderListReq orderListReq) {
        startPage();
        List<OrderTicketsListDao> list = iKylinOrderTicketsAdminService.orderList(orderListReq);
        return getDataTable(list);
    }

    /**
     * 订单详情
     */
    @Log(title = "演出订单", businessType = BusinessType.DETAIL)
    @RequiresPermissions("kylin:order:orderlist:detail")
    @GetMapping("/orderList/detail/{orderId}")
    public String addPerformance(@PathVariable("orderId") String orderId, ModelMap mmap) {
        OrderDetailsAdminVo orderDetailsVo = iKylinOrderTicketsAdminService.orderDetails(orderId);
        mmap.put("orderDetailsVo", orderDetailsVo);
        return prefix + "/orderList/details";
    }

    /**
     * 获取第三方列表
     */
    @Log(title = "演出订单-三方", businessType = BusinessType.LIST)
    @GetMapping("/orderList/getSponsorList")
    @ResponseBody
    public AjaxResult getSponsorList() {
        List<PerformanceSponsorDao> performanceSponsorList = kylinPerformancesService.getPerformanceSponsorList(null);
        AjaxResult ajax = new AjaxResult();

        ajax.put("code", 200);
        ajax.put("value", performanceSponsorList);
        return ajax;
    }

    /**
     * 获取第三方列表
     */
    @Log(title = "演出订单-初始化转赠 [只支持 transferStatus = 5]]", businessType = BusinessType.LIST)
    @GetMapping("/orderList/initTransfer")
    @ResponseBody
    public AjaxResult initTransfer(@RequestParam("orderId") String orderId) {
        String result = iKylinOrderTicketsAdminService.initTransfer(orderId);
        return this.success(result);
    }
}
