package com.liquidnet.service.chime.controller;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.chime.biz.ChimeUserBiz;
import com.liquidnet.service.chime.dto.ChimeUserInfoDto;
import com.liquidnet.service.chime.dto.ChimeUserListQueryReqDto;
import com.liquidnet.service.chime.dto.NewPageResult;
import com.liquidnet.service.chime.dto.PerformanceDto;
import com.liquidnet.service.chime.service.IChimePerformanceService;
import com.liquidnet.service.chime.service.IChimeUserService;
import com.liquidnet.service.feign.kylin.api.FeignKylinForChimeClient;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 演出相关
 * @class: ChimePerformanceController
 * @Package com.liquidnet.service.chime.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/6 11:43
 */
@Api(tags = "在场-演出相关")
@RestController
@RequestMapping("performance")
@Validated
public class ChimePerformanceController {
    @Autowired
    private IChimePerformanceService chimePerformanceService;

    @Autowired
    private IChimeUserService chimeUserService;

    @Autowired
    private FeignKylinForChimeClient feignKylinForChimeClient;

    @Autowired
    private ChimeUserBiz chimeUserBiz;

    @GetMapping("myPerformanceList")
    @ApiOperation("已购票的演出")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(type = "query", dataType = "int", name = "page", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "size", value = "每页数量"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "orderBy", value = "排序字段 时间timeStart"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sort", value = "排序方式[DESC ASC]"),
    })
    public ResponseDto<List<PerformanceDto>> myPerformanceList(
            @RequestParam(defaultValue = "") String userId,
            @RequestParam(defaultValue = "1") int page,
            @RequestParam(defaultValue = "10") int size,
            @RequestParam(defaultValue = "") String orderBy,
            @RequestParam(defaultValue = "") String sort
    ) {
//        List<PerformanceDto> performanceDtoList = new ArrayList<>();
//        for(int i=0;i<10;i++){
//            PerformanceDto dto = PerformanceDto.getNew();
//            dto.setPerformancesId(IDGenerator.get32UUID());
//            dto.setTitle("已购票演出00"+(i+1));
//            dto.setImgPoster("https://img.zhengzai.tv/other/2021/08/04/865b8c442e7c4fb6a9f3d9b17a8e5b80.jpg");
//            dto.setTimeStart("2021-09-08 12:00:00");
//            dto.setTimeEnd("2021-10-08 12:00:00");
//            dto.setCityName("北京");
//            dto.setJoinUserCount(123+(i*2));
//            performanceDtoList.add(dto);
//        }

        ResponseDto<List<KylinPerformanceVo>> responseDto = feignKylinForChimeClient.myPerformancesList();
        List<PerformanceDto> performanceDtoList = null;
        if(StringUtil.isNotNull(responseDto.getData())){
            List<KylinPerformanceVo> kylinPerformanceVoList = responseDto.getData();
            performanceDtoList = chimeUserBiz.buildPerformanceDtoList(kylinPerformanceVoList);
        }

        return ResponseDto.success(performanceDtoList);
    }


    @GetMapping("localPerformanceList")
    @ApiOperation("本地最近演出列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "cityName", value = "城市名称", required = true),
            @ApiImplicitParam(type = "query", dataType = "int", name = "days", value = "时间范围 几天 今天1 三天3。。。"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "type", value = "演出类型 101音乐节 102小型演出(livehouse演出) 103巡演 演出类型只有这几个了"),

            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isDiscount", value = "是否会员优惠 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isAdvance", value = "是否优先 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isExclusive", value = "是否会员专属 0 1"),

            @ApiImplicitParam(type = "query", dataType = "String", name = "orderBy", value = "排序字段 时间timeStart"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sort", value = "排序方式[DESC ASC]"),
    })
    public ResponseDto<HashMap<String, Object>> localPerformanceList(
            @RequestParam(defaultValue = "") String cityName,
            @RequestParam(defaultValue = "0") int days,
            @RequestParam(defaultValue = "0") int type,

            @RequestParam(defaultValue = "") Integer isDiscount,
            @RequestParam(defaultValue = "") Integer isAdvance,
            @RequestParam(defaultValue = "") Integer isExclusive,

            // 排序
            @RequestParam(defaultValue = "") String orderBy,
            @RequestParam(defaultValue = "") String sort
    ) {

        ResponseDto<HashMap<String, Object>> responseDto  = feignKylinForChimeClient.localList(cityName, days,type,isDiscount, isAdvance, isExclusive, orderBy, sort);

        if(StringUtil.isNotNull(responseDto.getData())){
            String jsonStr = JSON.toJSONString(responseDto.getData().get("list"));
            List<KylinPerformanceVo> kylinPerformanceVoList = JsonUtils.fromJson(jsonStr, new TypeReference<List<KylinPerformanceVo>>() {});
            List<PerformanceDto> performanceDtoList = chimeUserBiz.buildPerformanceDtoList(kylinPerformanceVoList);;
            responseDto.getData().put("list",performanceDtoList);
        }

        return responseDto;
    }


    @GetMapping("getUserListByCon")
    @ApiOperation("查询用户列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performanceId", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sex", value = "性别"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "pageNum", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "int", name = "pageSize", value = "每页数量"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "tags", value = "兴趣标签"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "orderBy", value = "排序字段 时间timeStart"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sort", value = "排序方式[DESC ASC]"),
    })
    public ResponseDto<NewPageResult<ChimeUserInfoDto>> getUserListByCon(
            @RequestParam(defaultValue = "") String performanceId,
            @RequestParam(defaultValue = "") String sex,
            @RequestParam(defaultValue = "1") int pageNum,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(defaultValue = "") String tags,
            @RequestParam(defaultValue = "") String orderBy,
            @RequestParam(defaultValue = "") String sort
    ) {
        ChimeUserListQueryReqDto reqDto = ChimeUserListQueryReqDto.getNew();
        reqDto.setPerformanceId(performanceId);
        reqDto.setPageNum(pageNum);
        reqDto.setPageSize(pageSize);
        reqDto.setOrderItem(orderBy);
        reqDto.setOrderSc(sort);
        reqDto.setSex(sex);
        reqDto.setTags(tags);
//        PageInfo<ChimeUserInfoDto> pageInfo = chimePerformanceService.getUserListByCon(reqDto);
        NewPageResult<ChimeUserInfoDto> pageInfo = chimePerformanceService.getUserListByCon(reqDto);

        //切换场次
        chimeUserService.switchPerformanceId(performanceId);

        //根据演出id判断当前用户是否在场
        boolean isOnline = chimeUserBiz.userIsOnline(performanceId);
        pageInfo.setIsOnline(isOnline);
        return ResponseDto.success(pageInfo);
    }
}
