package com.liquidnet.service.kylin.interceptor;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.web.filter.GlobalAuthorityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KylinAuthorityInterceptor extends GlobalAuthorityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(KylinAuthorityInterceptor.class);

    @Autowired
    RedisUtil redisUtil;

    @Override
    public String getAccessTokenForStation(String msokey) {
        String val = null;
        try {
            val = (String) redisUtil.get(msokey);
        } catch (Exception e) {
            log.error("KYLIN:Authority Check Exception", e);
        }
        return val;
    }
}
