package com.liquidnet.service.kylin.controller.partner;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinBuyNoticeVo;
import com.liquidnet.service.kylin.service.impl.partner.KylinBuyNoticePartnerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 购票须知表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-18
 */
@Api(tags = "第三方-购票须知",position = 1004)
@RestController
@RequestMapping("partner/buyNotice")
public class KylinBuyNoticeParnterController {

    @Autowired
    private KylinBuyNoticePartnerServiceImpl buyNoticePartnerService;

    @GetMapping(value = "")
    @ApiOperation(value = "购票须知列表",position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<KylinBuyNoticeVo>> copyPerformance() {
        PageInfo<KylinBuyNoticeVo> result = buyNoticePartnerService.getBuyNotice();
        if (null == result) {
            return ResponseDto.failure("查询失败");
        } else {
            return ResponseDto.success(result);
        }
    }

}
