package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinGoodsInfoDetailVo", description = "商品SPU详情")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinGoodsInfoDetailVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -4712015317981742851L;
    @ApiModelProperty(position = 22, value = "规格展现方式[1-常规|2-组合]")
    private String specMode;
    @ApiModelProperty(position = 51, value = "规格信息")
    private List<GoblinGoodsSpecVo> specVoList;
    @ApiModelProperty(position = 21, value = "商品视频地址")
    private String video;
    @ApiModelProperty(position = 40, value = "商品图片列表")
    private List<String> imageList;
    @ApiModelProperty(position = 13, value = "商品名称[100]")
    private String name;
    @ApiModelProperty(position = 15, value = "销售价-原价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 52, value = "商品标签列表")
    private List<GoblinGoodsTagVo> tagVoList;
    @ApiModelProperty(position = 53, value = "商品服务支持列表")
    private List<GoblinServiceSupportVo> serviceSupportVoList;
    @ApiModelProperty(position = 54, value = "音乐人、艺术家、IP列表")
    private List<GoblinGoodsExtagVo> extagVoList;
    @ApiModelProperty(position = 20, value = "封面图片地址[256]")
    private String coverPic;
    @ApiModelProperty(position = 19, value = "商品详情", example = "商品详情...")
    private String details;
    @ApiModelProperty(position = 10, value = "店铺ID")
    private String storeId;
    @ApiModelProperty(position = 16, value = "价格区间MIN[20,2]")
    private BigDecimal priceGe;
    @ApiModelProperty(position = 17, value = "价格区间MAX[20,2]")
    private BigDecimal priceLe;

    @ApiModelProperty(position = 60, value = "活动Id")
    private String marketId;
    private static final GoblinGoodsInfoDetailVo obj = new GoblinGoodsInfoDetailVo();

    public static GoblinGoodsInfoDetailVo getNew() {
        try {
            return (GoblinGoodsInfoDetailVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsInfoDetailVo();
        }
    }
/*    public int compareTo(GoblinGoodsInfoVo arg0) {
        return this.getCount().compareTo(arg0.getCount());
    }*/

}
