package com.liquidnet.commons.lang.util;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

public class CurrentUtil {
    public static final String uID = "uid";
    public static final String uTag = "u-tag";
    public static final String uToken = "u-token";
    public static final String CLI_SOURCE = "source";
    public static final String CLI_VERSION = "version";

    public static String getToken() {
        String authToken = ServletUtils.getRequest().getHeader(uToken);
        return StringUtils.isEmpty(authToken) ? "" : authToken;
    }

    public static Map getTokenClaims() {
        String utag = ServletUtils.getRequest().getHeader(uTag);

        // TODO: 2021/5/14 dev联调API未启用token默认使用1
        if (StringUtils.isEmpty(utag)) {
            Map<String, Object> map = new HashMap<>();
            map.put("mobile", "000");
            map.put("nickname", "111");
            map.put("uid", "1");
            return map;
        }

        return JsonUtils.fromJson(utag, Map.class);
    }

    public static String getCurrentUid() {
        String uid = ServletUtils.getRequest().getHeader(uID);
        // TODO: 2021/5/14 dev联调API未启用token默认使用1
        return StringUtils.isEmpty(uid) ? "1" : uid;
    }

    public static String getCliSource() {
        return ServletUtils.getRequest().getHeader(CLI_SOURCE);
    }

    public static String getCliVersion() {
        return ServletUtils.getRequest().getHeader(CLI_VERSION);
    }
}
