package com.liquidnet.service.goblin.param;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 组件排序
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinFrontMoudleIndexParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 组件排序id
     */
    private String moudleIndexId;

    /**
     * 名字
     */
    private String moudleName;

    /**
     * 顺序
     */
    private Integer indexs;

    /**
     * 修改时间
     */
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    private LocalDateTime updateTime;

    /**
     * 创建时间
     */
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createTime;

    /**
     * 0未删除1已删除
     */
    private Integer delTag;

    /**
     * 0展示2不展示
     */
    private Integer status;


}
