package com.liquidnet.service.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.liquidnet.commons.lang.util.IdentityUtils;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ErrorMapping;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class Utils {

    @Autowired
    private SmileRedisUtils smileRedisUtils;

    public boolean validate(String realName, String cardNo) {
        //查看是否之前这个 身份证和 名字(1：验证失败 2：验证成功)

        String status = smileRedisUtils.getValidate(realName, cardNo);
        if (null != status && "1".equals(status)) {
            log.info("身份证和信息错误之前已经储存了。不需要调用第三方识别");
            return false;
        }
        if(null != status && "2".equals(status)){
            log.info("身份证和信息已经效验了。不需要调用第三方识别");
            return true;
        }
        String respStr = IdentityUtils.aliThird(realName, cardNo), respErrorCode = null;
        JsonNode respJNode = JsonUtils.fromJson(respStr, JsonNode.class);
        if (null == respJNode || !"0".equals(respErrorCode = String.valueOf(respJNode.get("error_code")))) {
            log.debug("###实名认证失败[{}]", respJNode);
            ErrorMapping.ErrorMessage errorMessage = ErrorMapping.get("10102");
            smileRedisUtils.setValidate(realName, cardNo, "1");
            return false;
        }
        smileRedisUtils.setValidate(realName, cardNo, "2");
        return true;
    }
}
