package com.liquidnet.service.feign.auth.rsc;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-adam",
        contextId = "FeignAuthorityClient", path = "adam",
        url = "${liquidnet.service.adam.url}",
        fallback = FallbackFactory.Default.class)
public interface FeignAuthorityClient {

    @PostMapping("ath/check")
    ResponseDto<String> check(@RequestParam(value = "seal") String seal);
}
