package com.liquidnet.common.third.xuper.constant;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: XuperEnum
 * @Package com.liquidnet.common.third.xuper.constant
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/22 11:50
 */
public class XuperEnum {
    /**
     * 资产分类。1：艺术品 2：收藏品 3：门票 4：酒店
     */
    public enum assetTypeEnum{
        ARTWORK("1","艺术品"),
        COLLECTION("2","收藏品"),
        TICKETS("3","门票"),
        HOTEL("4","酒店");

        private String code;
        private String message;
        assetTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public assetTypeEnum getEnumByCode(String code){
            assetTypeEnum[] arry = assetTypeEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 资产发行状态 1：初始 3：发行中 4：发行成功 5:冻结中 6:已冻结 7：封禁中 8:已封禁
     */
    public enum AssetPublishStatusEnum{
        INIT("1","初始"),
        PUBLISHING("3","发行中"),
        PUBLISH_SUCCESS("4","发行成功"),
        FREEZING("5","冻结中"),
        BANNEDING("6","封禁中"),
        BANNEDED("7","已封禁");


        private String code;
        private String message;
        AssetPublishStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public AssetPublishStatusEnum getEnumByCode(String code){
            AssetPublishStatusEnum[] arry = AssetPublishStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }

        public String getMessage(){
            return message;
        }
    }

    /**
     * 资产授予状态 0:已上链 1:授予中 4:转移中 5: 核销中 6: 已核销 10:异常详情参考错误码和状态码
     */
    public enum AssetGrantStatusEnum{
        GRANT_SUCCESS("0","已上链"),
        GRANTING("1","授予中"),
        TRANSFERING("4","转移中"),
        CANCELING("5","核销中"),
        CANCELED("6","已核销"),
        OTHER_ERROR("10","异常详情参考错误码和状态码");


        private String code;
        private String message;
        AssetGrantStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public AssetGrantStatusEnum getEnumByCode(String code){
            AssetGrantStatusEnum[] arry = AssetGrantStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }

        public String getMessage(){
            return message;
        }
    }
}
