package com.liquidnet.service.sweet.dto.vo;

import com.liquidnet.service.sweet.entity.SweetIntegralActivity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class IntegralActivityVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -303399210433737206L;

    @ApiModelProperty(value = "活动id")
    private String integralActivityId;

    @ApiModelProperty(value = "活动名称")
    private String activityTitle;

    @ApiModelProperty(value = "活动图片")
    private String activityImg;

    private static final IntegralActivityVo obj = new IntegralActivityVo();
    public static IntegralActivityVo getNew() {
        try {
            return (IntegralActivityVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new IntegralActivityVo();
        }
    }

    public IntegralActivityVo copy(SweetIntegralActivity source) {
        if (null == this) return this;
        this.setIntegralActivityId(source.getIntegralActivityId());
        this.setActivityTitle(source.getActivityTitle());
        this.setActivityImg(source.getActivityImg());
        return this;
    }

}
