package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class GoblinListVo implements Serializable, Cloneable {
    @ApiModelProperty(value = "名单id")
    private String listId;
    @ApiModelProperty(value = "优先购名称")
    private String name;
    @ApiModelProperty(value = "开始时间")
    private String timeStart;
    @ApiModelProperty(value = "结束时间")
    private String timeEnd;
    @ApiModelProperty(value = "是否有黑名单[1-有|2-无]")
    private Integer hasBlack;
    @ApiModelProperty(value = "商品数量")
    private Integer skuCount;

    private static final GoblinListVo obj = new GoblinListVo();

    public static GoblinListVo getNew() {
        try {
            return (GoblinListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinListVo();
    }
}
