package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCouponFilterParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtCouponInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtCouponListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponBasicVo;

public interface IGoblinstoreMgtCouponService {
    /**
     * 商铺活动:优惠券列表
     *
     * @param mgtCouponFilterParam GoblinStoreMgtCouponFilterParam
     * @return PagedResult<GoblinStoreMgtCouponListVo>
     */
    PagedResult<GoblinStoreMgtCouponListVo> couponList(GoblinStoreMgtCouponFilterParam mgtCouponFilterParam);

    /**
     * 商铺活动:优惠券添加
     *
     * @param uid                UID
     * @param storeCouponBasicVo GoblinStoreCouponBasicVo
     */
    void couponAdd(String uid, GoblinStoreCouponBasicVo storeCouponBasicVo);

    /**
     * 商铺活动:优惠券详情
     *
     * @param storeId       店铺ID
     * @param storeCouponId 优惠券ID
     * @return GoblinStoreMgtCouponInfoVo
     */
    GoblinStoreMgtCouponInfoVo couponInfo(String storeId, String storeCouponId);
//
//    /**
//     * 商铺活动:商品编辑:优惠券编辑
//     *
//     * @param uid                   UID
//     * @param storeMgtGoodsAddParam GoblinStoreMgtGoodsAddParam
//     * @return boolean
//     */
//    boolean goodsEdit(String uid, GoblinStoreMgtGoodsAddParam storeMgtGoodsAddParam);
//
//    /**
//     * 商铺活动:商品编辑:SKU编辑
//     *
//     * @param uid                       UID
//     * @param storeMgtGoodsEditSkuParam GoblinStoreMgtGoodsEditSkuParam
//     * @param goodsInfoVo               GoblinGoodsInfoVo
//     * @param del优惠券SpecMap             Map<String, String>
//     * @param beUpdate优惠券SpecFlg        boolean
//     * @return boolean
//     */
//    boolean goodsEditStock(String uid, GoblinStoreMgtGoodsEditSkuParam storeMgtGoodsEditSkuParam,
//                         GoblinGoodsInfoVo goodsInfoVo, Map<String, String> del优惠券SpecMap, boolean beUpdate优惠券SpecFlg);
//
//    /**
//     * 商铺活动:上下架商品
//     *
//     * @param storeMgtGoodsActionParam GoblinStoreMgtGoodsActionParam
//     * @param uid                      UID
//     * @param shelvesFlg               true:上架|false:下架
//     */
//    void goodsShelvesProcessing(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam, String uid, boolean shelvesFlg);
//
//    /**
//     * 商铺活动:删除商品
//     *
//     * @param storeMgtGoodsActionParam GoblinStoreMgtGoodsActionParam
//     * @param uid                      UID
//     */
//    void goodsRemove(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam, String uid);
}
