package com.liquidnet.service.dragon.controller;

import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.dto.DragonPayOrderQueryRespDto;
import com.liquidnet.service.dragon.service.IDragonOrdersService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PayController
 * @Package com.liquidnet.service.dragon.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/9 12:29
 */
@Slf4j
@RestController
@RequestMapping("pay")
public class PayController {
    @Autowired
    private IDragonOrdersService dragonOrdersService;

    /**
     * 电脑网页支付宝支付
     * @return
     */
    @PostMapping("/dragonPay")
    @ApiOperation("Dragon支付")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "payType", value = "支付类型:alipay,wepay,iappay", example = "alipay"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "deviceFrom", value = "设备来源:web,wap,app,js,apple", example = "wap"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "type", value = "业务类型:TICKET,PRODUCT,COST,MBEANS,LIVE,VIDEO,VIP,CLUB,STRAWBERRY", example = "TICKET"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "price", value = "支付金额", example = "0.1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "name", value = "订单名称", example = "测试订单001"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "detail", value = "订单描述", example = "测试订单001"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderCode", value = "订单编号", example = "ORDER0001"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "clientIp", value = "客户端ip", example = "127.0.0.1"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "notifyUrl", value = "通知url", example = "devdragon.zhengzai.tv"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "createDate", value = "订单创建时间", example = "2021-07-13 13:00:00"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "expireTime", value = "订单过期时间", example = "5"),
    })
    @ResponseBody
    public ResponseDto<DragonPayBaseRespDto> dragonPay(
            @RequestParam(value = "payType") @NotNull(message = "支付类型不能为空") String payType,
            @RequestParam(value = "deviceFrom") @NotNull(message = "设备来源不能为空") String deviceFrom,
            @RequestParam(value = "openId",required = false) String openId,
            @RequestParam(value = "type") @NotNull(message = "业务类型不能为空") String type,
               @RequestParam(value = "price") @NotNull(message = "支付金额不能为空") BigDecimal price,
               @RequestParam(value = "name") @NotNull(message = "订单名称不能为空") String name,
               @RequestParam(value = "detail") @NotNull(message = "订单描述不能为空") String detail,
               @RequestParam(value = "orderCode") @NotNull(message = "订单编号不能为空") String orderCode,
               @RequestParam(value = "clientIp") @NotNull(message = "客户端ip不能为空") String clientIp,
               @RequestParam(value = "notifyUrl") @NotNull(message = "通知Url不能为空") String notifyUrl,
               @RequestParam(value = "returnUrl",required = false)  String returnUrl,
//               @RequestParam(value = "quitUrl",required = false)  String quitUrl,
               @RequestParam(value = "showUrl",required = false)  String showUrl,
//               @RequestParam(value = "code",required = false)  String code,
               @RequestParam(value = "createDate",required = true)  String createDate,
               @RequestParam(value = "expireTime",required = true)  String expireTime){
        long startTime = System.currentTimeMillis();
        //为什么在js和applet中才需要判断open_id?
        if(payType.equalsIgnoreCase(DragonConstant.PayChannelEnum.WEPAY.getCode())){
            if(deviceFrom.equalsIgnoreCase(DragonConstant.DeviceFromEnum.JS.getCode())||deviceFrom.equalsIgnoreCase(DragonConstant.DeviceFromEnum.APPLET.getCode())) {
                if (StringUtil.isEmpty(openId)) {
                    return ResponseDto.failure("微信支付openId不能为空!");
                }
            }
        }
        DragonPayBaseReqDto dragonPayBaseReqDto = new DragonPayBaseReqDto();
        dragonPayBaseReqDto.setPayType(payType);
        dragonPayBaseReqDto.setDeviceFrom(deviceFrom);
        dragonPayBaseReqDto.setOpenId(openId);
        dragonPayBaseReqDto.setType(type);
        dragonPayBaseReqDto.setPrice(price);
        dragonPayBaseReqDto.setName(name);
        dragonPayBaseReqDto.setDetail(detail);
        dragonPayBaseReqDto.setOrderCode(orderCode);
        dragonPayBaseReqDto.setClientIp(clientIp);
        dragonPayBaseReqDto.setNotifyUrl(notifyUrl);
        dragonPayBaseReqDto.setReturnUrl(returnUrl);
//        dragonPayBaseReqDto.setQuitUrl(quitUrl);
        dragonPayBaseReqDto.setShowUrl(showUrl);
//        dragonPayBaseReqDto.setCode(code);
        dragonPayBaseReqDto.setCreateDate(createDate);
        dragonPayBaseReqDto.setExpireTime(expireTime);
        ResponseDto<DragonPayBaseRespDto> responseDto = dragonOrdersService.dragonPay(dragonPayBaseReqDto);
        log.info("dragonPay->总耗时:{}",(System.currentTimeMillis() - startTime)+"毫秒");
        return responseDto;
    }

    @GetMapping("/checkOrder")
    @ApiOperation("订单查询")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "code", value = "", example = "PAY202107131522368438531155")
    })
    @ResponseBody
    public ResponseDto<DragonPayOrderQueryRespDto> checkOrder(@RequestParam(value = "code") @NotNull(message = "支付编号不能为空！") String code){
        DragonPayOrderQueryRespDto respDto = dragonOrdersService.checkOrderStatusByCode(code);
        return ResponseDto.success(respDto);
    }

    @GetMapping("/manulNotify")
    @ApiOperation("手动通知商户")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "code", value = "", example = "PAY202107131522368438531155")
    })
    @ResponseBody
    public ResponseDto<Map<String,String>> manulNotify(@RequestParam(value = "code") @NotNull(message = "支付编号不能为空！") String code){
        boolean respDto = dragonOrdersService.manulNotify(code);
        Map<String,String> rs = new HashMap<>();
        rs.put("code",code);
        rs.put("result",""+respDto);
        return ResponseDto.success(rs);
    }
}
