package com.liquidnet.service.reconciliation.service.impl;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.reconciliation.biz.ReconciliationFileDownBiz;
import com.liquidnet.service.reconciliation.biz.ReconciliationFileParserBiz;
import com.liquidnet.service.reconciliation.biz.ReconciliationValidateBiz;
import com.liquidnet.service.reconciliation.constant.ReconConstants.BankChannelEnum;
import com.liquidnet.service.reconciliation.constant.ReconConstants.BatchStatusEnum;
import com.liquidnet.service.reconciliation.entity.LrAccountCheckBatch;
import com.liquidnet.service.reconciliation.service.core.BuildNoService;
import com.liquidnet.service.reconciliation.service.ILrAccountCheckBatchService;
import com.liquidnet.service.reconciliation.strategy.accounting.ComparingAccountStrategyContext;
import com.liquidnet.service.reconciliation.vo.ReconciliationEntityVo;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 *
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class ReconciliationCheckBizTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ReconciliationFileDownBiz fileDownBiz;
    @Autowired
    private ReconciliationFileParserBiz parserBiz;
    @Autowired
    private ComparingAccountStrategyContext comparingAccountStrategyContext;
    @Autowired
    private ReconciliationValidateBiz validateBiz;
    @Autowired
    private ILrAccountCheckBatchService batchService;
    @Autowired
    private BuildNoService buildNoService;

    @Test
    public void testTaskAccountCheck() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

        try {
            // 获取业务biz实体

                // 获取需要对账的对账单时间
                Date billDate = DateUtil.addDay(new Date(), -1);
                // 获取对账渠道
                String interfaceCode = BankChannelEnum.LIQUIDNET_WALLET.getCode();

                /** step1:判断是否对过账 **/
                LrAccountCheckBatch batch = new LrAccountCheckBatch();
                Boolean checked = validateBiz.isChecked(interfaceCode, billDate);
                if (checked) {
                    log.info("账单日[" + sdf.format(billDate) + "],支付方式[" + interfaceCode + "],已经对过账，不能再次发起自动对账。");
                }
                // 创建对账批次
                batch.setCreater("reconciliationSystem");
                batch.setCreateTime(new Date());
                batch.setBillDate(billDate);
                batch.setBatchNo(buildNoService.buildReconciliationNo(interfaceCode));
                batch.setBankType(interfaceCode);

                /** step2:对账文件下载 **/
                File file = null;
                try {
                    log.info("ReconciliationFileDownBiz,对账文件下载开始");
                    file = fileDownBiz.downReconciliationFile(interfaceCode, billDate);
                    if (file == null) {
                    }
                    log.info("对账文件下载结束");
                } catch (Exception e) {
                    log.error("对账文件下载异常:", e);
                    batch.setStatus(BatchStatusEnum.FAIL.name());
                    batch.setRemark("对账文件下载异常");
                    batchService.save(batch);
                }

                /** step3:解析对账文件 **/
                List<ReconciliationEntityVo> bankList = null;
                try {
                    log.info("=ReconciliationFileParserBiz=>对账文件解析开始>>>");

                    // 解析文件
                    bankList = parserBiz.parser(batch, file, billDate, interfaceCode);
                    // 如果下载文件异常，退出
                    if (BatchStatusEnum.ERROR.name().equals(batch.getStatus())) {

                    }
                    log.info("对账文件解析结束");
                } catch (Exception e) {
                    log.error("对账文件解析异常:", e);
                    batch.setStatus(BatchStatusEnum.FAIL.name());
                    batch.setRemark("对账文件解析异常");
                    batchService.save(batch);
                }

                /** step4:对账流程 **/
                try {
                    comparingAccountStrategyContext.getStrategy(interfaceCode).check(bankList, batch);
                } catch (Exception e) {
                    log.error("对账异常:", e);
                    batch.setStatus(BatchStatusEnum.FAIL.name());
                    batch.setRemark("对账异常");
                    batchService.save(batch);
                }

            /** step5:清理缓冲池 **/
            // 如果缓冲池中有三天前的数据就清理掉并记录差错
            validateBiz.validateScratchPool();
        } catch (Exception e) {
            log.error("roncoo-app-reconciliation error:", e);
        }

    }

    @Test
    public void testCheck(){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        // 获取需要对账的对账单时间
        Date billDate = DateUtil.addDay(new Date(), -4);
        // 获取对账渠道
        String interfaceCode = BankChannelEnum.LIQUIDNET_WALLET.getCode();

        /** step1:判断是否对过账 **/
        LrAccountCheckBatch batch = new LrAccountCheckBatch();
        Boolean checked = validateBiz.isChecked(interfaceCode, billDate);
        if (checked) {
            log.info("账单日[" + sdf.format(billDate) + "],支付方式[" + interfaceCode + "],已经对过账，不能再次发起自动对账。");
        }
    }

}