package com.liquidnet.service.account.wallet.dto;

import com.liquidnet.service.account.wallet.dto.base.WalletCallParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * WalletRegisterParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/21
 */
@ApiModel(value = "WalletRegisterParam", description = "Parameters of wallet registration")
public class WalletRegisterParam extends WalletCallParam {
    private static final long serialVersionUID = 5388697981117712059L;
    @ApiModelProperty(position = 11, required = true, value = "User association ID [64]", example = "1001")
    private String userExtId;
    @ApiModelProperty(position = 12, required = true, value = "User association name [150]", example = "John")
    private String userExtName;
    @ApiModelProperty(position = 13, required = true, value = "Wallet currency alphabetic code [5]", example = "USD")
    private String currency;
    @ApiModelProperty(position = 14, required = false, value = "Wallet alias [100]", example = "TEST184001")
    private String alias;

    public String getUserExtId() {
        return userExtId;
    }

    public void setUserExtId(String userExtId) {
        this.userExtId = userExtId;
    }

    public String getUserExtName() {
        return userExtName;
    }

    public void setUserExtName(String userExtName) {
        this.userExtName = userExtName;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}
