package com.liquidnet.service.account.wallet.service.processor;

import com.liquidnet.service.account.common.ErrorConstants;
import com.liquidnet.service.account.wallet.dto.WalletTransactionQueryResult;
import com.liquidnet.service.account.wallet.dto.base.WalletContextParam;
import com.liquidnet.service.account.wallet.service.FinBizTransService;
import com.liquidnet.service.account.wallet.service.WalletProcessorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Service
public class WalletTransQueryProcessor extends WalletProcessorService {
    private static final Logger log = LoggerFactory.getLogger(WalletTransQueryProcessor.class);
    @Autowired
    private FinBizTransService bizTransService;

    @Override
    public WalletTransactionQueryResult checkInputParams(WalletContextParam context) {
//        if (CollectionUtils.isEmpty(context.getStrList())) {
//            return new WalletTransactionQueryResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, "Invalid strList<transNo>");
//        }
        if (!StringUtils.isEmpty(context.getStrListType()) && !Arrays.asList("0", "1").contains(context.getStrListType())) {
            return new WalletTransactionQueryResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, "Invalid strListType");
        }
        return new WalletTransactionQueryResult();
    }

    @Override
    public WalletTransactionQueryResult checkBussinessLogic(WalletContextParam context) {
        return new WalletTransactionQueryResult();
    }

    @Override
    public WalletTransactionQueryResult doBussiness(WalletContextParam context) {
        Map<String, Object> parameter = new HashMap<>();
        parameter.put("balanceAvailableIsNotNull", "1");
        parameter.put("walletNoEqualTo", context.getWalletNo());
        parameter.put("1".equals(context.getStrListType()) ? "tracingNoIn" : "transNoIn", context.getStrList());
        return new WalletTransactionQueryResult(bizTransService.queryTransDetails(parameter));
    }
}
