package com.liquidnet.service.bank.currencycloud.controller;

import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.common.BankResultDto;
import com.liquidnet.service.bank.config.swagger.BankSwaggerApiVersionConstant;
import com.liquidnet.service.bank.currencycloud.dto.BankCcPaymentCreateParam;
import com.liquidnet.service.bank.currencycloud.entity.BankCcPayment;
import com.liquidnet.service.bank.currencycloud.service.IBankCcPaymentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 下发表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-13
 */
@Api(tags = "payment")
@Slf4j
@RestController
@RequestMapping("/bank-cc-payment")
public class BankCcPaymentController {

    @Autowired
    private IBankCcPaymentService bankCcPaymentService;

    @SwaggerApiVersion(group = BankSwaggerApiVersionConstant.API_CC)
    @ApiOperation(value = "cc create payment")
    @PostMapping(value = "/create")
    public ResponseDto<BankCcPayment> create(@RequestBody BankCcPaymentCreateParam param) {
        BankResultDto<BankCcPayment> resultDto = bankCcPaymentService.createPayment(
                param.getContactId(),
                param.getPaymentParam(),
                param.getBeneficiaryParam(),
                param.getPayerParam());

        return BankResultDto.getResponseDto(resultDto);
    }

}
