package com.liquidnet.service.bank.currencycloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.currencycloud.client.CurrencyCloudClient;
import com.currencycloud.client.exception.ApiException;
import com.currencycloud.client.model.FundingAccount;
import com.currencycloud.client.model.FundingAccounts;
import com.liquidnet.service.bank.common.BankErrorCode;
import com.liquidnet.service.bank.common.BankResultDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcFundingAccountDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcFundingAccountsParam;
import com.liquidnet.service.bank.currencycloud.service.IBankCcFundingService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-13
 */
@Slf4j
@Service("bankCcFundingService")
public class BankCcFundingServiceImpl implements IBankCcFundingService {

    @Autowired
    CurrencyCloudClient currencyCloudClient;

    @Override
    public BankResultDto<List<BankCcFundingAccountDto>> getFundingAccount(String accountId, String currency) {
        BankCcFundingAccountsParam param = new BankCcFundingAccountsParam(currency, accountId);
        BankResultDto<FundingAccounts> resultDto = this.findFundingAccounts(param);
        if (resultDto.isSuccess()) {
            FundingAccounts data = resultDto.getData();
            List<FundingAccount> list = data.getFundingAccounts();
            List<BankCcFundingAccountDto> dtoList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(list)) {
                for (FundingAccount fundingAccount : list) {
                    BankCcFundingAccountDto dto = new BankCcFundingAccountDto();
                    BeanUtils.copyProperties(fundingAccount, dto);
                    dtoList.add(dto);
                }
            }
            return BankResultDto.success(dtoList);

        }
        return BankResultDto.failure(resultDto.getCode(), resultDto.getMessage());
    }

    @Override
    public BankResultDto<FundingAccounts> findFundingAccounts(BankCcFundingAccountsParam param) {
        String currency = param.getCurrency();
        String accountId = param.getAccountId();
        String paymentType = param.getPaymentType();
        String logFx = "cc find funding accounts.param=" + JSON.toJSONString(param);
        try {
            FundingAccounts fundingAccounts = currencyCloudClient.findFundingAccounts(currency, accountId, paymentType, null);
            return BankResultDto.success(fundingAccounts);
        } catch (ApiException e) {
            log.error(logFx + "api eroor, errorCode=[{}],errors=[{}]", e.getErrorCode(), e.getErrors());
            return BankResultDto.failure(e.getErrorCode(), e.getMessage());
        } catch (Exception e) {
            log.error(logFx + "exception eroor:[{}]", JSON.toJSONString(e));
            return BankResultDto.failure(BankErrorCode.BANK_CC_001001);
        }

    }

}
