package com.liquidnet.service.reconciliation.service.core;


import com.liquidnet.service.reconciliation.entity.LrAccountCheckBatch;
import com.liquidnet.service.reconciliation.entity.LrAccountCheckBatchSub;
import com.liquidnet.service.reconciliation.entity.LrAccountCheckMistake;
import com.liquidnet.service.reconciliation.entity.LrAccountCheckMistakeScratchPool;

import java.util.List;
import java.util.Map;

/**
 * 对账数据事务一致性service.
 */
public interface ILrAccountCheckTransactionService {

	/**
	 * 保存
	 */
	void saveDatasaveDate(LrAccountCheckBatch batch, List<LrAccountCheckMistake> mistakeList, List<LrAccountCheckMistakeScratchPool> insertScreatchRecordList, List<LrAccountCheckMistakeScratchPool> removeScreatchRecordList,Map<String, LrAccountCheckBatchSub>batchSubMap);

	/**
	 * 
	 * @param list
	 * @param mistakeList
	 */
	void removeDateFromPool(List<LrAccountCheckMistakeScratchPool> list, List<LrAccountCheckMistake> mistakeList);

	/**
	 * 差错处理
	 * 
	 * @param id
	 *            差错记录id
	 * @param handleType
	 *            差错处理方式
	 * @param handleRemark
	 *            差错备注
	 */
	void handle(String id, String handleType, String handleRemark);

}