package com.liquidnet.service.reconciliation.controller.task;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: TODO
 * @class: TaskCreateBatchLiquidnetWalletController
 * @Package com.liquidnet.service.reconciliation.controller.task
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:00
 */
@Api(tags = "recon-task")
@RestController
@RequestMapping("/recon/task/createBatch")
public class TaskCreateBatchController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "liquidnetWallet create batch task")
    @GetMapping(value = "/liquidnetWalletCreateBatch")
    public void createBatchByBankChannel(String bankChannelCode,String billDate) {
        log.info("createBatchByBankChannel: bankChannelCode:{}", bankChannelCode,billDate);
//        return ResponseEntity.ok("This is `service-example` api.test: ");
    }

//    public static void main(String[] args) {
//
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
//
//        try {
//            // 加载Spring配置文件
//            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[] { "spring-context.xml" });
//            // 初始化SpringContextUtil
//            final SpringContextUtil ctxUtil = new SpringContextUtil();
//            ctxUtil.setApplicationContext(context);
//
//            @SuppressWarnings("rawtypes")
//            // 获取全部有效的对账接口(目前是写死了，可以做持久化到数据库，再查出来)
//            List reconciliationInterList = ReconciliationInterface.getInterface();
//
//            // 获取业务biz实体
//            ReconciliationFileDownBiz fileDownBiz = (ReconciliationFileDownBiz) SpringContextUtil.getBean("reconciliationFileDownBiz");
//            ReconciliationFileParserBiz parserBiz = (ReconciliationFileParserBiz) SpringContextUtil.getBean("reconciliationFileParserBiz");
//            ReconciliationCheckBiz checkBiz = (ReconciliationCheckBiz) SpringContextUtil.getBean("reconciliationCheckBiz");
//            ReconciliationValidateBiz validateBiz = (ReconciliationValidateBiz) SpringContextUtil.getBean("reconciliationValidateBiz");
//            RpAccountCheckBatchService batchService = (RpAccountCheckBatchService) SpringContextUtil.getBean("rpAccountCheckBatchService");
//            BuildNoService buildNoService = (BuildNoService) SpringContextUtil.getBean("buildNoService");
//
//            // 根据不同的渠道发起对账
//            for (int num = 0; num < reconciliationInterList.size(); num++) {
//                // 判断接口是否正确
//                ReconciliationInterface reconciliationInter = (ReconciliationInterface) reconciliationInterList.get(num);
//                if (reconciliationInter == null) {
//                    log.info("对账接口信息" + reconciliationInter + "为空");
//                    continue;
//                }
//                // 获取需要对账的对账单时间
//                Date billDate = DateUtil.addDay(new Date(), -reconciliationInter.getBillDay());
//                // 获取对账渠道
//                String interfaceCode = reconciliationInter.getInterfaceCode();
//
//                /** step1:判断是否对过账 **/
//                RpAccountCheckBatch batch = new RpAccountCheckBatch();
//                Boolean checked = validateBiz.isChecked(interfaceCode, billDate);
//                if (checked) {
//                    log.info("账单日[" + sdf.format(billDate) + "],支付方式[" + interfaceCode + "],已经对过账，不能再次发起自动对账。");
//                    continue;
//                }
//                // 创建对账批次
//                batch.setCreater("reconciliationSystem");
//                batch.setCreateTime(new Date());
//                batch.setBillDate(billDate);
//                batch.setBatchNo(buildNoService.buildReconciliationNo());
//                batch.setBankType(interfaceCode);
//
//                /** step2:对账文件下载 **/
//                File file = null;
//                try {
//                    log.info("ReconciliationFileDownBiz,对账文件下载开始");
//                    file = fileDownBiz.downReconciliationFile(interfaceCode, billDate);
//                    if (file == null) {
//                        continue;
//                    }
//                    log.info("对账文件下载结束");
//                } catch (Exception e) {
//                    log.error("对账文件下载异常:", e);
//                    batch.setStatus(BatchStatusEnum.FAIL.name());
//                    batch.setRemark("对账文件下载异常");
//                    batchService.saveData(batch);
//                    continue;
//                }
//
//                /** step3:解析对账文件 **/
//                List<ReconciliationEntityVo> bankList = null;
//                try {
//                    log.info("=ReconciliationFileParserBiz=>对账文件解析开始>>>");
//
//                    // 解析文件
//                    bankList = parserBiz.parser(batch, file, billDate, interfaceCode);
//                    // 如果下载文件异常，退出
//                    if (BatchStatusEnum.ERROR.name().equals(batch.getStatus())) {
//                        continue;
//                    }
//                    log.info("对账文件解析结束");
//                } catch (Exception e) {
//                    log.error("对账文件解析异常:", e);
//                    batch.setStatus(BatchStatusEnum.FAIL.name());
//                    batch.setRemark("对账文件解析异常");
//                    batchService.saveData(batch);
//                    continue;
//                }
//
//                /** step4:对账流程 **/
//                try {
//                    checkBiz.check(bankList, interfaceCode, batch);
//                } catch (Exception e) {
//                    log.error("对账异常:", e);
//                    batch.setStatus(BatchStatusEnum.FAIL.name());
//                    batch.setRemark("对账异常");
//                    batchService.saveData(batch);
//                    continue;
//                }
//
//            }
//
//            /** step5:清理缓冲池 **/
//            // 如果缓冲池中有三天前的数据就清理掉并记录差错
//            validateBiz.validateScratchPool();
//        } catch (Exception e) {
//            log.error("roncoo-app-reconciliation error:", e);
//        }
//
//    }
}
