package com.liquidnet.service.reconciliation.strategy.infodata.impl;

import com.liquidnet.service.api.sequence.feign.FeignSequenceClient;
import com.liquidnet.service.reconciliation.constant.ReconConstants.BankChannelEnum;
import com.liquidnet.service.reconciliation.entity.LrFundflowLiquidnetWallet;
import com.liquidnet.service.reconciliation.entity.LrInfoflowLiquidnetAdam;
import com.liquidnet.service.reconciliation.service.ILrFundflowLiquidnetWalletService;
import com.liquidnet.service.reconciliation.strategy.infodata.IGetInfoDataStrategy;
import com.liquidnet.service.reconciliation.strategy.infodata.annotation.StrategyGetInfoDataHandler;
import com.liquidnet.service.reconciliation.vo.ReconciliationEntityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: liquidnet-wallet
 * @class: LiquidnetWalletGetFundDataStrategyImpl
 * @Package com.liquidnet.service.reconciliation.strategy.transtype.impl
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:58
 */
@Component
@StrategyGetInfoDataHandler(BankChannelEnum.LIQUIDNET_WALLET)
public class GetInfoDataStrategyLiquidnetWalletImpl implements IGetInfoDataStrategy {
    @Autowired
    private FeignSequenceClient feignSequenceClient;

    @Autowired
    private ILrFundflowLiquidnetWalletService lrFundflowLiquidnetWalletService;

    @Override
    public List<ReconciliationEntityVo> getTransInfoData(Map<String, Object> paramMap) {
        List<LrFundflowLiquidnetWallet>  infoFlowList = lrFundflowLiquidnetWalletService.list();

        List<ReconciliationEntityVo> reconList = new ArrayList<>();
        infoFlowList.stream().forEach(fundRecord ->{
            ReconciliationEntityVo reconVo = ReconciliationEntityVo.getNew();
            reconVo.setId(feignSequenceClient.nextId().toString());
//            reconVo.setBankChannel();
//            reconVo.setBatchNo();
//            reconVo.setBillDate();
//            reconVo.setOrderNo();
//            reconVo.setTransactionId();
//            reconVo.setTransType();
//            reconVo.setCurrency();
//            reconVo.setAmount();
//            reconVo.setCostFee();
//            reconVo.setRefundAmount();
//            reconVo.setTradeStatus();
//            reconVo.setRefTransId();
//            reconVo.setCheckResult();
//            reconVo.setOrderTime();
//            reconVo.setTransDate();
//            reconVo.setTransTime();
//            reconVo.setBankOrderNo();
//            reconVo.setBankTrxNo();
            reconList.add(reconVo);
        });
        return reconList;
    }
}
