package com.liquidnet.service.goblin.param;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Api
@Data
public class CouponCanUseAllParam implements Serializable, Cloneable {
    @ApiModelProperty(name = "spuIds", value = "spuId集合",required = true)
    @NotNull @NotBlank
    private List<String> spuIds;
    @ApiModelProperty(dataType = "String", name = "uid", value = "用户id",example = "10",required = true)
    private String uid;

    private static final CouponCanUseAllParam obj = new CouponCanUseAllParam();

    public static CouponCanUseAllParam getNew() {
        try {
            return (CouponCanUseAllParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CouponCanUseAllParam();
    }

}
