package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.GoblinGoodsSpecDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "GoblinGoodsSkuInfoVo", description = "商品SKU信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinGoodsSkuInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 7139250447538358198L;
    @ApiModelProperty(position = 10, value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 12, value = "单品的条码[50]默认为系统编码，也可手动输入商家自己的编码")
    private String skuNo;
    @ApiModelProperty(position = 12, value = "单品条码[32]")
    private String skuBarCode;
    @ApiModelProperty(position = 12, value = "商家编码[64]")
    private String skuErpCode;
    @ApiModelProperty(position = 12, value = "ERP类型[WANGDIAN-旺店通]")
    private String erpType;
    @ApiModelProperty(position = 12, value = "ERP托管[0-否|1-是]，默认0")
    private int erpHosting;
    @ApiModelProperty(position = 12, value = "ERP仓库编号")
    private String erpWarehouseNo;
    @ApiModelProperty(position = 12, value = "商品类型[0-常规｜1-数字藏品｜2-券类商品]")
    private int skuType;
    @ApiModelProperty(position = 13, value = "单品的名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "单品的副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 15, value = "单品默认图片的URL[256]")
    private String skuPic;
    @ApiModelProperty(position = 15, value = "单品详情展示文件URL[256]")
    private String skuWatch;
    @ApiModelProperty(position = 15, value = "展示文件类型[1-图片|2-视频|3-模型]")
    private String watchType;
    @ApiModelProperty(position = 15, value = "展示预览图片URL[256]")
    private String skuWatchPic;
    @ApiModelProperty(position = 15, value = "素材原始文件类型[1-图片|2-视频|3-模型]")
    private String materialType;
    @ApiModelProperty(position = 15, value = "素材原始文件URL")
    private String materialUrl;
    @ApiModelProperty(position = 16, value = "ISBN，针对CD/图书等[50]")
    private String skuIsbn;
    @ApiModelProperty(position = 17, value = "总库存")
    private Integer stock;
    @ApiModelProperty(position = 18, value = "单品库存")
    private Integer skuStock;
    @ApiModelProperty(position = 18, value = "盲盒命中率[0.01~100%]0标识不参与盲盒，null标识均摊")
    private BigDecimal hitRatio;
    @ApiModelProperty(position = 19, value = "预警库存")
    private Integer warningStock;
    @ApiModelProperty(position = 20, value = "单品销售价-原价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 21, value = "单品现价[20,2]")
    private BigDecimal price;
    @ApiModelProperty(position = 21, value = "IOS商品价格[20,2]")
    private BigDecimal priceV;
    @ApiModelProperty(position = 21, value = "IOS商品价格ID")
    private String productId;
    @ApiModelProperty(position = 22, value = "单品会员价格[20,2]")
    private BigDecimal priceMember;
    @ApiModelProperty(position = 23, value = "单品的重量[20,2]")
    private BigDecimal weight;
    @ApiModelProperty(position = 23, value = "单品简介[256]", example = "单品简介...")
    private String intro;
    @ApiModelProperty(position = 23, value = "单品详情", example = "单品详情...")
    private String details;
    @ApiModelProperty(position = 24, value = "购买限制[0-全部用户|1-仅会员|2-指定用户]")
    private String buyFactor;
    @ApiModelProperty(position = 25, value = "购买限制人员名单[购买限制为2-指定用户时必填]")
    private String buyRoster;
    @ApiModelProperty(position = 26, value = "限量[0-无限制|X:限购数量]")
    private Integer buyLimit;
    @ApiModelProperty(position = 27, value = "商品的店铺ID，如果是平台的则为0")
    private String storeId;
    @ApiModelProperty(position = 27, value = "上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]")
    private String shelvesHandle;
    @ApiModelProperty(position = 27, value = "预约上架时间[上架处理方式为3-预约定时上架时需要指定]")
    private String shelvesTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 27, value = "开售时间")
    private LocalDateTime saleStartTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 27, value = "停售时间")
    private LocalDateTime saleStopTime;
    @ApiModelProperty(position = 28, value = "单品有效期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime skuValidity;
    @ApiModelProperty(position = 29, value = "是否是虚拟商品[0-否|1-是]")
    private String virtualFlg;
    @ApiModelProperty(position = 30, value = "审核状态[0-初始编辑|1-审核中|2-审核不通过|3-审核通过]")
    private String status;
    @ApiModelProperty(position = 31, value = "审核拒绝原因[256]")
    private String reason;
    @ApiModelProperty(position = 32, value = "单品上架状态[0-待上架|1-下架|2-违规|3-上架]")
    private String shelvesStatus;
    @ApiModelProperty(position = 32, value = "是否售罄[0-否|1-是]")
    private String soldoutStatus;
    @ApiModelProperty(position = 33, value = "是否隐藏[0-默认展示|1-隐藏]")
    private String skuAppear;
    @ApiModelProperty(position = 33, value = "是否购买[0-否|1-是]")
    private String skuCanbuy;
    @ApiModelProperty(position = 33, value = "是否盲盒[0-否|1-是]")
    private String unbox;
    @ApiModelProperty(position = 33, value = "盲盒开启时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime openingTime;
    @ApiModelProperty(position = 33, value = "盲盒开启时限[单位秒]")
    private Integer openingLimit;
    @ApiModelProperty(position = 33, value = "NFT路由[zxinchain-至信链|xuper-百度超级链]")
    private String routeType;
    @ApiModelProperty(position = 33, value = "NFT上传声明状态[0-待上传|1-已声明|2-声明失败|9-声明中]")
    private Integer upchain;
    @ApiModelProperty(position = 33, value = "NFT预览图访问URL")
    private String displayUrl;
    @ApiModelProperty(position = 33, value = "NFT素材访问URL")
    private String nftUrl;
    @ApiModelProperty(position = 33, value = "NFT系列ID")
    private String seriesId;
    @ApiModelProperty(position = 33, value = "NFT系列HASH")
    private String seriesHash;
    @ApiModelProperty(position = 33, value = "NFT藏品HASH")
    private String nftHash;
    @ApiModelProperty(position = 33, value = "NFT系列声明时间")
    private String declareAt;

    /**
     * ---------------------------- 券类商品-代金券属性 ----------------------------
     */
    @ApiModelProperty(position = 33, value = "是否实名[0-否｜1-是，表示该商品需要实名关联]")
    private Integer isTrueName;
    @ApiModelProperty(position = 33, value = "业务类别[0-全场｜1-演出｜2-商品｜3-优先购]")
    private Integer busiType;
    @ApiModelProperty(position = 33, value = "券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券｜101-优先券]")
    private Integer couType;
    @ApiModelProperty(position = 33, value = "适用范围[101-音乐节｜102-小型演出（livehouse演出）｜103-巡演]")
    private Integer useScope;
    @ApiModelProperty(position = 33, value = "面值")
    private BigDecimal valFace;
    @ApiModelProperty(position = 33, value = "购买后（单位天）有效期，与生效/过期时间二选一")
    private Integer validity;
    @ApiModelProperty(position = 33, value = "生效时间[yyyy-MM-dd HH:mm:ss]")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime effectAt;
    @ApiModelProperty(position = 33, value = "过期时间[yyyy-MM-dd HH:mm:ss]")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime expireAt;
    /**
     * ---------------------------- 以上为券类商品-代金券属性 ----------------------------
     */

    @ApiModelProperty(position = 34, value = "删除标记[0-未删除|1-删除]")
    private String delFlg;
    @ApiModelProperty(position = 35, value = "上架时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime shelvesAt;
    @ApiModelProperty(position = 36, value = "活动Id")
    private String marketId;
    @ApiModelProperty(position = 37, value = "物流模版ID")
    private String logisticsTemplate;

    private String createdBy;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    private String updatedBy;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;
    private String deletedBy;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime deletedAt;

    @ApiModelProperty(position = 40, value = "单品AR文件URL-iOS版")
    private String arUrlIos;
    @ApiModelProperty(position = 40, value = "单品AR文件URL-android版")
    private String arUrlAndroid;

    @ApiModelProperty(position = 40, value = "单品规格信息")
    private List<GoblinGoodsSpecDto> skuSpecList;
    @ApiModelProperty(position = 41, value = "单品音乐人标签[藏品类型时使用]")
    private List<GoblinGoodsExtagVo> extagVoList;

    /* -------------------------------- 只展示，不存储 -------------------------------- */

    @ApiModelProperty(position = 50, value = "剩余库存")
    private Integer surplusStock;

    private static final GoblinGoodsSkuInfoVo obj = new GoblinGoodsSkuInfoVo();

    public String getUnbox() {
        if (skuType == 0 || skuType == 2) {
            return unbox == null ? "0" : unbox;
        } else {
            return unbox;
        }
    }

    public static GoblinGoodsSkuInfoVo getNew() {
        try {
            return (GoblinGoodsSkuInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsSkuInfoVo();
        }
    }
}
