package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.ISweetCollectionReservationService;
import com.liquidnet.service.sweet.vo.SweetCollectionReservationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 数字藏品预约活动表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-18
 */
@Api(tags = "活动-数字藏品预约活动")
@RestController
@RequestMapping("/collectionReservation")
public class SweetCollectionReservationController {

    @Autowired
    private ISweetCollectionReservationService reservationService;

    @GetMapping("info")
    @ApiOperation("活动状态")
    public ResponseDto<SweetCollectionReservationVo> info() {
        return reservationService.info();
    }

    @PostMapping("time")
    @ApiOperation("设置活动结束时间")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "endTime", value = "结束时间")
    })
    public ResponseDto<Boolean> time(
            @RequestParam() String endTime
    ) {
        return reservationService.time(endTime);
    }

    @PostMapping("create")
    @ApiOperation("添加预约记录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "nickname", value = "昵称", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "mobile", value = "手机号", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "mailbox", value = "邮箱", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "enterpriseName", value = "公司名称", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "title", value = "职务", required = true)
    })
    public ResponseDto<Boolean> create(
            @RequestParam() String nickname,
            @RequestParam() String mobile,
            @RequestParam() String mailbox,
            @RequestParam() String enterpriseName,
            @RequestParam() String title
    ) {
        return reservationService.create(nickname, mobile, mailbox, enterpriseName, title);
    }

}
