package com.liquidnet.service.platform.service.basicServices;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.adam.dto.vo.admin.AdminUpushVo;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.entity.AdminUpush;
import com.liquidnet.service.kylin.mapper.AdminUpushMapper;
import com.liquidnet.service.kylin.service.admin.IAdminUpushService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.LinkedList;

/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-02
 */
@Service
public class AdminUpushServiceImpl extends ServiceImpl<AdminUpushMapper, AdminUpush> implements IAdminUpushService {

    @Value("${liquidnet.aliyun.oss.imgUrl}")
    private String imgUrl;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;

    public PageInfo<AdminUpushVo> lists(HttpServletRequest request, Integer page, Integer size) {
        String source = request.getHeader("source");
        PageInfo<AdminUpushVo> voPageInfo = null;
        Object adminUpushVo = null;
        if (null != source) {
            if (source.equals("IOS")) {
                adminUpushVo = redisDataSourceUtil.getRedisKylinUtil().get(KylinRedisConst.ADMIN_UPUSH_LIST_IOS);
            } else if (source.equals("Android")) {
                adminUpushVo = redisDataSourceUtil.getRedisKylinUtil().get(KylinRedisConst.ADMIN_UPUSH_LIST_ANDROID);
            }
        }
        if (null == adminUpushVo || page > 1) { // 不分页了 大于第一页返回空
            voPageInfo = PageInfo.of(new LinkedList<>());
        } else {
            LinkedList<AdminUpushVo> pushList = (LinkedList<AdminUpushVo>) adminUpushVo;
            for (AdminUpushVo info : pushList) {
                if (!info.getImg().isEmpty()) {
                    String img = imgUrl + info.getImg();
                    info.setImg(img);
                }
            }
            voPageInfo = PageInfo.of(pushList);
            voPageInfo.setTotal(pushList.size());
        }
        return voPageInfo;
    }

}
