package com.liquidnet.service.feign.platform.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PutMapping;

@Component
@FeignClient(
        name = "liquidnet-service-platform",
        contextId = "FeignPlatformCandyTaskClient",
        path = "platform",
        url = "${liquidnet.service.platform.url}",
        fallback = FallbackFactory.Default.class
)
public interface FeignPlatformCandyTaskClient {

    @PutMapping("ccoupon/task/mgt/issue/coupons")
    ResponseDto<String> mgtIssueCoupons();

    @PutMapping("ccoupon/task/due/redeem")
    ResponseDto<String> dueProcessForRedeem();

    @PutMapping("ccoupon/task/due/common")
    ResponseDto<String> dueProcessForCommon();

    @PutMapping("ccoupon/task/due/user")
    ResponseDto<String> dueProcessForUser();
}
