package com.liquidnet.service.sweet.dto.param.poster;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@ApiModel(value = "SweetStrawMusicianParam", description = "音乐人")
@Data
public class SweetStrawMusicianParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(position = 10, required = true, value = "lineupNum", example = "lineupNum")
    @NotBlank(message = "lineupNum不能为空")
    private String lineupNum;

    @ApiModelProperty(position = 10, required = true, value = "musicianId", example = "musicianId")
    @NotBlank(message = "musicianId不能为空")
    private Integer musicianId;

    @ApiModelProperty(position = 10, required = true, value = "musicianName", example = "musicianName")
    @NotBlank(message = "musicianName不能为空")
    private String musicianName;

}
