package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.client.admin.common.exception.BusinessException;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.OrderMallOrderVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreOrderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class GoblinImportServiceImpl implements IGoblinImportService {

    @Autowired
    private IGoblinStoreOrderService iGoblinStoreOrderService;

    @Override
    public String importExpress(List<OrderMallOrderVo> mallOrdertVoList) {
        if (StringUtils.isNull(mallOrdertVoList) || mallOrdertVoList.size() == 0) {
            throw new BusinessException("导入用户数据不能为空！");
        }
        int count = 0;
        for (OrderMallOrderVo mallOrderVo : mallOrdertVoList) {
            ResponseDto<Boolean> express = iGoblinStoreOrderService.express(mallOrderVo.getOrderCode(), null, mallOrderVo.getMailNo());
            count++;
        }
        return String.valueOf(count);
    }
}
