package com.liquidnet.service.kylin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 批量退款表
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinRefundBatches implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * refund_batch_id
     */
    private String refundBatchId;

    /**
     * 目标id target_type=1为演出id
     */
    private String targetId;

    /**
     * 目标名称 target_type=1为演出名称
     */
    private String targetTitle;

    /**
     * 目标类型 1演出
     */
    private Integer targetType;

    /**
     * 批量退款状态 1申请退款 2取消退款 3运营驳回审核 4运营通过审核 5财务驳回审核 6财务通过审核
     */
    private Integer status;

    /**
     * 批量退款总金额
     */
    private BigDecimal totalPrice;

    /**
     * 实际批量退款总金额
     */
    private BigDecimal realTotalPrice;

    /**
     * 批量退款总数量
     */
    private Integer totalNum;

    /**
     * 实际批量退款总数量
     */
    private Integer realTotalNum;

    /**
     * 申请时支付宝需退款总金额
     */
    private BigDecimal totalRefundAlipay;

    /**
     * 申请时微信需退款总金额
     */
    private BigDecimal totalRefundWepay;

    /**
     * 快递费总金额支付宝
     */
    private BigDecimal totalPriceExpressAlipay;

    /**
     * 快递费总金额微信
     */
    private BigDecimal totalPriceExpressWepay;

    /**
     * 批量退款原因
     */
    private String reason;

    /**
     * 批量退款备注
     */
    private String remark;

    /**
     * 驳回原因
     */
    private String reject;

    /**
     * 回绝原因
     */
    private String refuse;

    /**
     * 批量申请人id
     */
    private Integer applicantId;

    /**
     * 批量申请人名称
     */
    private String applicantName;

    /**
     * 批量申请时间
     */
    private LocalDateTime applicantAt;

    /**
     * 批量审核人id
     */
    private Integer auditorId;

    /**
     * 批量审核人名称
     */
    private String auditorName;

    /**
     * 批量审核时间
     */
    private LocalDateTime auditorAt;

    /**
     * 批量执行人id
     */
    private Integer executorId;

    /**
     * 批量执行人名称
     */
    private String executorName;

    /**
     * 批量执行时间
     */
    private LocalDateTime executorAt;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
