package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "AdamMemberPriceVo", description = "会员价格")
@Data
public class AdamMemberPriceVo implements Serializable {
    private static final long serialVersionUID = -8106910166417645208L;
    @ApiModelProperty(position = 1, value = "会员价格ID")
    private String memberPriceId;
    @ApiModelProperty(position = 2, value = "会员类型ID")
    private String memberId;
    @ApiModelProperty(position = 3, value = "价格状态[0-不可用,1-上线中,2-已下线]")
    private Integer status;
    @ApiModelProperty(position = 4, value = "价格包名称")
    private String name;
    @ApiModelProperty(position = 5, value = "原价")
    private BigDecimal price;
    @ApiModelProperty(position = 6, value = "折扣价")
    private BigDecimal priceFixed;
    @ApiModelProperty(position = 7, value = "有效天数")
    private Integer days;
    @ApiModelProperty(position = 8, value = "会员包须知")
    private String detail;
    @ApiModelProperty(position = 9, value = "创建时间")
    private String createdAt;
    @ApiModelProperty(position = 10, value = "更新时间")
    private String updatedAt;
}
