package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.liquidnet.client.admin.common.core.text.Convert;
import com.liquidnet.client.admin.zhengzai.kylin.domain.KylinOrderTickets;
import com.liquidnet.client.admin.zhengzai.kylin.mapper.KylinOrderTicketsMapper;
import com.liquidnet.client.admin.zhengzai.kylin.service.IKylinOrderTicketsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 订单Service业务层处理
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
@Service
public class KylinOrderTicketsServiceImpl implements IKylinOrderTicketsService 
{
    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;

    /**
     * 查询订单
     * 
     * @param mid 订单ID
     * @return 订单
     */
    @Override
    public KylinOrderTickets selectKylinOrderTicketsById(Integer mid)
    {
        return kylinOrderTicketsMapper.selectKylinOrderTicketsById(mid);
    }

    /**
     * 查询订单列表
     * 
     * @param kylinOrderTickets 订单
     * @return 订单
     */
    @Override
    public List<KylinOrderTickets> selectKylinOrderTicketsList(KylinOrderTickets kylinOrderTickets)
    {
        return kylinOrderTicketsMapper.selectKylinOrderTicketsList(kylinOrderTickets);
    }

    /**
     * 新增订单
     * 
     * @param kylinOrderTickets 订单
     * @return 结果
     */
    @Override
    public int insertKylinOrderTickets(KylinOrderTickets kylinOrderTickets)
    {
        return kylinOrderTicketsMapper.insertKylinOrderTickets(kylinOrderTickets);
    }

    /**
     * 修改订单
     * 
     * @param kylinOrderTickets 订单
     * @return 结果
     */
    @Override
    public int updateKylinOrderTickets(KylinOrderTickets kylinOrderTickets)
    {
        return kylinOrderTicketsMapper.updateKylinOrderTickets(kylinOrderTickets);
    }

    /**
     * 删除订单对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteKylinOrderTicketsByIds(String ids)
    {
        return kylinOrderTicketsMapper.deleteKylinOrderTicketsByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除订单信息
     * 
     * @param mid 订单ID
     * @return 结果
     */
    @Override
    public int deleteKylinOrderTicketsById(Integer mid)
    {
        return kylinOrderTicketsMapper.deleteKylinOrderTicketsById(mid);
    }
}
