package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.KylinBannersVo;
import com.liquidnet.service.kylin.entity.KylinBanners;
import com.liquidnet.service.kylin.service.admin.IKylinBannersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-02
 */
@Service
public class BannersServiceImpl implements IKylinBannersService {

    @Value("${liquidnet.al-oss.imgUrl}")
    private String imgUrl;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    RedisUtil redisUtil;

    public List<KylinBanners> blist(String position, String provinceName) {
        String nowTime = DateUtil.getNowTime();
        List<KylinBanners> list = (List<KylinBanners>) redisUtil.get(KylinRedisConst.ADMIN_BANNER_LIST);
        for (KylinBanners info : list) {
            // 时间
            String StartTime = info.getOnlineStartTime();
            String endTime = info.getOnlineEndTime();
            if (!StartTime.isEmpty() && !endTime.isEmpty()) {
                if (DateUtil.compareStrDay(nowTime, StartTime) < 0) { // 当前时间小雨开始时间 还未开始呢
                    list.remove(info);
                }
                if (DateUtil.compareStrDay(endTime, nowTime) > 0) { // 解释时间大于当前时间 已过期
                    list.remove(info);
                }
            }

            // list
            if (info.getPromotionType() != 1) {
                List<String> pList = info.getPositionList();
                Boolean pis = false;
                for (String positionName : pList) {
                    if (positionName.equals(position)) {
                        pis = true;
                    }
                }
                if (!pis) {
                    list.remove(info);
                }

                List<String> proList = info.getProvincesList();
                Boolean prois = false;
                for (String proName : proList) {
                    if (proName.equals(provinceName)) {
                        prois = true;
                    }
                }
                if (!prois) {
                    list.remove(info);
                }
            }

            String setCoverImg = imgUrl + info.getCoverImg();
            info.setCoverImg(setCoverImg);
        }
        return list;
    }

}
