package com.liquidnet.service.kylin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@ApiModel(value = "WqTempVo")
@Data
public class WqTempVo implements Cloneable{

    @ApiModelProperty(value = "订单id")
    private String orderId;
    @ApiModelProperty(value = "收货人姓名")
    private String name;
    @ApiModelProperty(value = "代理id")
    private String Province;
    @ApiModelProperty(value = "省份行政编码")
    private String county;
    @ApiModelProperty(value = "城市")
    private String city;
    @ApiModelProperty(value = "收货地址")
    private String address;
    @ApiModelProperty(value = "区县")
    private String phone;
    @ApiModelProperty(value = "快递单号")
    private String mailNo;
    @ApiModelProperty(value = "是否是万青补偿订单")
    private Integer isTemp;

    private static final WqTempVo obj = new WqTempVo();

    public static WqTempVo getNew() {
        try {
            return (WqTempVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new WqTempVo();
        }
    }
}
