package com.liquidnet.service.sweet.service;

import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityCouponVo;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityDrawVo;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityPrizeApiVo;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityDraw;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 积分活动抽奖记录表 服务类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-26
 */
public interface ISweetIntegralActivityDrawService extends IService<SweetIntegralActivityDraw> {

    ResponseDto<IntegralActivityPrizeApiVo> create(String integralActivityId);

    ResponseDto<PagedResult<IntegralActivityDrawVo>> drawList(String integralActivityId, Integer pageNum);

    ResponseDto<List<IntegralActivityDrawVo>> winPrizeUser(String integralActivityId);

    ResponseDto perfectAddress(String drawId, String receivingAddressesId);

    ResponseDto<IntegralActivityDrawVo> detail(String drawId);

    ResponseDto collectCoupon(String couponId);

    ResponseDto<List<IntegralActivityCouponVo>> couponList(String prizeId, String integralActivityId);
}
