package com.liquidnet.service.consumer.service.processor;

import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.SqlMessage;
import com.liquidnet.service.consumer.service.IBaseDao;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * ConsumerProcessor.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2021/4/29
 */
@Slf4j
@Component
public class ConsumerProcessor {
    @Resource
    IBaseDao baseDao;

//    @RabbitListener(bindings = @QueueBinding(
//            exchange = @Exchange("queue.sql"),
//            key = "rk",
//            value = @Queue("queue.sql.main")
//    ))
//    @RabbitHandler
//    public void consumerSql(Message message) {
//        log.info("consumer sql:{}", message);
//    }

    @RabbitListener(queues = MQConst.QUEUES_SQL_MAIN)
    public void consumerSql(String msg) {
        SqlMessage sqlMessage = JsonUtils.fromJson(msg, SqlMessage.class);
        log.debug("consumer sql ==> Preparing:{}", JsonUtils.toJson(sqlMessage.getSqls()));
        log.debug("consumer sql ==> Parameters:{}", JsonUtils.toJson(sqlMessage.getArgs()));

        try {
            switch (sqlMessage.getExecType()) {
                case 1:
                    int i = baseDao.insertSqlAndReturnKeyId(sqlMessage.getSqls().get(0), sqlMessage.getArgs()[0].get(0));
                    log.debug("insertSqlAndReturnKeyId result of execution:{}", i);
                    break;
                case 2:
                    Boolean rstBatchSql = baseDao.batchSql(sqlMessage.getSqls().get(0), sqlMessage.getArgs()[0]);
                    log.debug("batchSql result of execution:{}", rstBatchSql);
                    break;
                case 3:
                    Boolean rstBatchSqls = baseDao.batchSqls(sqlMessage.getSqls(), sqlMessage.getArgs());
                    log.debug("batchSqls result of execution:{}", rstBatchSqls);
                    break;
                default:
                    break;
            }
        } catch (Exception e) {
            log.error("error", e);
        }
    }
}
