package com.liquidnet.service.galaxy.dto;

import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: NftInfo
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/23 13:16
 */
@Data
public class NftInfoDto {
    /**
     * nftId
     */
    private String nftId;
    /**
     * 所有者地址
     */
    private String ownerAddr;
    /**
     * 作者名，中文+英文(数字或符号为非法输入) 不超过30个字符
     */
    private String author;
    /**
     * 作品名字，中英文数字均可，不超过256个字符
     */
    private String name;
    /**
     * 作品url，不超过2048个字符 疑问：应该是发行的1024吧？
     */
    private String url;
    /**
     * 预览图url
     */
    private String displayUrl;
    /**
     * 作品hash
     */
    private String hash;
    /**
     * 此owner获得此nft的时间戳
     */
    private Long ownerGainedTime;
    /**
     * 作品简介，500个字符以内
     */
    private String desc;
    /**
     * 作品标签，【文创】，游戏，动漫，30个字符以内
     */
    private String flag;
    /**
     * 作品系列
     */
    private String seriesName;
    /**
     * 系列ID
     */
    private String seriesId;
    /**
     * 系列NFT总数
     */
    private Long seriesTotalNum;
    /**
     * 扩展字段，用户自定义，长度不超过1024个字符
     */
    private String metaData;
    /**
     * 发行者地址
     */
    private String publisherAddr;
    /**
     * 发行平台地址
     */
    private String publishPlatformAddr;
    /**
     * 系列偏移id
     */
    private Integer seriesIndexId;
    /**
     * 发行时交易hash
     */
    private String publishTxHash;
    /**
     * 1：可售 2：不可售
     */
    private Integer sellStatus;
    /**
     * 卖多少积分，可售状态下才有意义
     */
    private Long sellCount;
}
