package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.galaxy.dto.NftInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyQuerySeriesReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/7 16:27
 */
@ApiModel(value = "GalaxyQueryNftListRespDto", description = "NFT列表查询")
@Data
public class GalaxyQueryNftListRespDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "userId")
    private String userId;

    @ApiModelProperty(position = 1, required = true, value = "seriesId")
    private String seriesId;

    /**
     * 藏品总数
     */
    private Long total;
    /**
     * nft元信息列表
     */
    private List<NftInfoDto> nftList;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyQueryNftListRespDto obj = new GalaxyQueryNftListRespDto();

    public static GalaxyQueryNftListRespDto getNew() {
        try {
            return (GalaxyQueryNftListRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyQueryNftListRespDto();
        }
    }
}