package com.liquidnet.service.platform.service.express.shunfeng;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.kylin.dto.param.*;
import com.liquidnet.service.kylin.dto.vo.express.KylinOrderExpressRouteVo;
import com.liquidnet.service.kylin.dto.vo.express.KylinOrderExpressVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.IKylinOrderExpress;
import com.liquidnet.service.platform.utils.DataUtils;
import com.liquidnet.service.platform.utils.ShunfengSignUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 演出 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-05
 */
@Service
@Slf4j
public class PerformancesExpressCallbackServiceImpl extends ServiceImpl<KylinOrderExpressMapper, KylinOrderExpress> implements IKylinOrderExpress {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private ShunfengSignUtils shunfengSignUtils;

    @Autowired
    private KylinOrderExpressMapper kylinOrderExpressMapper;

    @Autowired
    private KylinOrderExpressFeeInfoMapper kylinOrderExpressFeeInfoMapper;

    @Autowired
    private KylinOrderExpressRouteMapper kylinOrderExpressRouteMapper;

    @Autowired
    private KylinOrderExpressStatusMapper kylinOrderExpressStatusMapper;

    @Autowired
    private KylinOrderTicketRelationsMapper kylinOrderTicketRelationsMapper;

    @Autowired
    HttpServletRequest httpServletRequest;

    @Autowired
    private DataUtils dataUtils;

    public boolean orderStatus(@RequestBody String params) {
        boolean res = shunfengSignUtils.receiveRequestAndCheckSign(params, httpServletRequest);
        if (res) {
            PerformanceExpressPushStatusParam performanceExpressPushStatusParam = JsonUtils.fromJson(params, PerformanceExpressPushStatusParam.class);
            KylinOrderExpressStatus kylinOrderExpressStatus = new KylinOrderExpressStatus();
            String orderExpressStatusId = IDGenerator.nextSnowId();

            KylinOrderExpress orderExpressInfo = kylinOrderExpressMapper.selectOne(new QueryWrapper<KylinOrderExpress>().eq("mailno", performanceExpressPushStatusParam.getWaybillNo()));
            kylinOrderExpressStatus.setOrderExpressStatusId(orderExpressStatusId);
            kylinOrderExpressStatus.setOrderExpressId(orderExpressInfo.getOrderExpressId());
            kylinOrderExpressStatus.setOrderStateCode(performanceExpressPushStatusParam.getOrderStateCode());
            kylinOrderExpressStatus.setOrderStateDesc(performanceExpressPushStatusParam.getOrderStateDesc());
            kylinOrderExpressStatus.setEmpCode(performanceExpressPushStatusParam.getEmpCode());
            kylinOrderExpressStatus.setEmpPhone(performanceExpressPushStatusParam.getEmpPhone());
            kylinOrderExpressStatus.setNetCode(performanceExpressPushStatusParam.getNetCode());
            kylinOrderExpressStatus.setLastTime(performanceExpressPushStatusParam.getLastTime());
            kylinOrderExpressStatus.setBookTime(performanceExpressPushStatusParam.getBookTime());
            kylinOrderExpressStatus.setCarrierCode(performanceExpressPushStatusParam.getCarrierCode());
            kylinOrderExpressStatus.setCreatedAt(DateUtil.getNowTime());
            kylinOrderExpressStatusMapper.insert(kylinOrderExpressStatus);
            return true;
        }

        return false;
    }

    public boolean orderFreightList(@RequestBody String params) {
        boolean res = shunfengSignUtils.receiveRequestAndCheckSign(params, httpServletRequest);
        if (res) {
            PerformanceExpressPushFreightParam performanceExpressPushFreightParam = JsonUtils.fromJson(params, PerformanceExpressPushFreightParam.class);
            KylinOrderExpress orderExpressInfo = kylinOrderExpressMapper.selectOne(new QueryWrapper<KylinOrderExpress>().eq("mailno", performanceExpressPushFreightParam.getWaybillNo()));
            String orderExpressId = orderExpressInfo.getOrderExpressId();

            kylinOrderExpressFeeInfoMapper.delete(new QueryWrapper<KylinOrderExpressFeeInfo>().eq("order_express_id", orderExpressId));

            List<PerformanceExpressPushFreightInfoParam> feeList = performanceExpressPushFreightParam.getFeeList();
            for (PerformanceExpressPushFreightInfoParam feeInfo : feeList) {
                KylinOrderExpressFeeInfo kylinOrderExpressFeeInfo = new KylinOrderExpressFeeInfo();
                String orderExpressFeeInfoId = IDGenerator.nextSnowId();
                kylinOrderExpressFeeInfo.setOrderExpressFeeInfoId(orderExpressFeeInfoId);
                kylinOrderExpressFeeInfo.setOrderExpressId(orderExpressId);
                kylinOrderExpressFeeInfo.setType(feeInfo.getFeeIndType().toString());
                kylinOrderExpressFeeInfo.setName(feeInfo.getFeeTypeCode());
                kylinOrderExpressFeeInfo.setValue(BigDecimal.valueOf(feeInfo.getFeeAmt()));
                kylinOrderExpressFeeInfo.setCreatedAt(DateUtil.getNowTime());
                kylinOrderExpressFeeInfoMapper.insert(kylinOrderExpressFeeInfo);
            }
            return true;
        }

        return false;
    }

    public boolean orderRoute(@RequestBody String params) {
        boolean res = shunfengSignUtils.receiveRequestAndCheckSign(params, httpServletRequest);
//        {"id":"123","mailno":"SF1020099313222","orderid":"NEW127745085969203221966686005","acceptTime":"2021-06-20 11:37:33","acceptAddress":"深圳市","remark":"顺丰已收件（测试推送）","opCode":"80","companyId":"557104628450889728","routeAddress":"https://devplatform.zhengzai.tv/platform/performancesExpress/orderRoute"}
        if (res) {
            PerformanceExpressPushRouteParam performanceExpressPushRouteParam = JsonUtils.fromJson(params, PerformanceExpressPushRouteParam.class);
            KylinOrderExpressRoute kylinOrderExpressRoute = new KylinOrderExpressRoute();
            String orderExpressRouteId = IDGenerator.nextSnowId();

            KylinOrderExpress orderExpressInfo = kylinOrderExpressMapper.selectOne(new QueryWrapper<KylinOrderExpress>().eq("mailno", performanceExpressPushRouteParam.getMailno()));
            KylinOrderExpress kylinOrderExpress = new KylinOrderExpress();
            kylinOrderExpress.setExpressStatus(Integer.valueOf(performanceExpressPushRouteParam.getOpCode()));
            kylinOrderExpressMapper.update(kylinOrderExpress,
                    Wrappers.lambdaQuery(KylinOrderExpress.class).eq(KylinOrderExpress::getOrderExpressId, orderExpressInfo.getOrderExpressId()));

            kylinOrderExpressRoute.setOrderExpressRouteId(orderExpressRouteId);
            kylinOrderExpressRoute.setOrderExpressId(orderExpressInfo.getOrderExpressId());
            kylinOrderExpressRoute.setAcceptAddress(performanceExpressPushRouteParam.getAcceptAddress());
            kylinOrderExpressRoute.setAcceptTotaltime(performanceExpressPushRouteParam.getAcceptTime());
            kylinOrderExpressRoute.setRemark(performanceExpressPushRouteParam.getRemark());
            kylinOrderExpressRoute.setOpcode(performanceExpressPushRouteParam.getOpCode());
            kylinOrderExpressRoute.setCreatedAt(DateUtil.getNowTime());
            kylinOrderExpressRouteMapper.insert(kylinOrderExpressRoute);

            KylinOrderExpressVo kylinOrderExpressVo = new KylinOrderExpressVo();
            BeanUtils.copyProperties(orderExpressInfo, kylinOrderExpressVo);
            kylinOrderExpressVo.setExpressStatus(Integer.valueOf(performanceExpressPushRouteParam.getOpCode()));
            dataUtils.setOrderExpressInfo(orderExpressInfo.getOrderTicketsId(), kylinOrderExpressVo);

            KylinOrderExpressRouteVo kylinOrderExpressRouteVo = new KylinOrderExpressRouteVo();
            BeanUtils.copyProperties(kylinOrderExpressRoute, kylinOrderExpressRouteVo);
            kylinOrderExpressRouteVo.setOrderTicketsId(orderExpressInfo.getOrderTicketsId());
            LinkedList<KylinOrderExpressRouteVo> routeList = dataUtils.getOrderExpressRoute(orderExpressInfo.getOrderTicketsId());
            if (null == routeList) {
                routeList = new LinkedList();
            }
            routeList.addFirst(kylinOrderExpressRouteVo);
            dataUtils.setOrderExpressRoute(orderExpressInfo.getOrderTicketsId(), routeList);

            return true;
        }

        return false;
    }

}